/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueOrException<V, E extends Throwable> {
    private final boolean _useValue;
    private final V _value;
    private final E _exception;

    private ValueOrException(V value, E exception, boolean useValue) {
        this._useValue = useValue;
        if (useValue) {
            this._value = value;
            this._exception = null;
        } else {
            this._value = null;
            this._exception = exception;
        }
    }

    public static <V, E extends Throwable> ValueOrException<V, E> makeValue(V value) {
        return new ValueOrException<V, Object>(value, null, true);
    }

    public static <V, E extends Throwable> ValueOrException<V, E> makeException(E exception) {
        return new ValueOrException<Object, E>(null, exception, false);
    }

    public V getValue() throws E {
        if (this._useValue) {
            return this._value;
        }
        throw this._exception;
    }
}

