/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.MalformedFrameException;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.TruncatedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodArgumentReader {
    private static final long INT_MASK = -1L;
    private final DataInputStream in;
    private int bits;
    private int bit;

    protected static long unsignedExtend(int value) {
        long extended = value;
        return extended & 0xFFFFFFFFFFFFFFFFL;
    }

    private void clearBits() {
        this.bits = 0;
        this.bit = 256;
    }

    public MethodArgumentReader(DataInputStream in) {
        this.in = in;
        this.clearBits();
    }

    public static final String readShortstr(DataInputStream in) throws IOException {
        byte[] b = new byte[in.readUnsignedByte()];
        in.readFully(b);
        return new String(b, "utf-8");
    }

    public final String readShortstr() throws IOException {
        this.clearBits();
        return MethodArgumentReader.readShortstr(this.in);
    }

    public static final LongString readLongstr(DataInputStream in) throws IOException {
        long contentLength = MethodArgumentReader.unsignedExtend(in.readInt());
        if (contentLength < Integer.MAX_VALUE) {
            byte[] buffer = new byte[(int)contentLength];
            in.readFully(buffer);
            return LongStringHelper.asLongString(buffer);
        }
        throw new UnsupportedOperationException("Very long strings not currently supported");
    }

    public final LongString readLongstr() throws IOException {
        this.clearBits();
        return MethodArgumentReader.readLongstr(this.in);
    }

    public final int readShort() throws IOException {
        this.clearBits();
        return this.in.readUnsignedShort();
    }

    public final int readLong() throws IOException {
        this.clearBits();
        return this.in.readInt();
    }

    public final long readLonglong() throws IOException {
        this.clearBits();
        return this.in.readLong();
    }

    public final boolean readBit() throws IOException {
        if (this.bit > 128) {
            this.bits = this.in.readUnsignedByte();
            this.bit = 1;
        }
        boolean result = (this.bits & this.bit) != 0;
        this.bit <<= 1;
        return result;
    }

    public final Map<String, Object> readTable() throws IOException {
        this.clearBits();
        return MethodArgumentReader.readTable(this.in);
    }

    public static final Map<String, Object> readTable(DataInputStream in) throws IOException {
        HashMap<String, Object> table = new HashMap<String, Object>();
        long tableLength = MethodArgumentReader.unsignedExtend(in.readInt());
        DataInputStream tableIn = new DataInputStream((InputStream)((Object)new TruncatedInputStream(in, tableLength)));
        Object value = null;
        while (tableIn.available() > 0) {
            String name = MethodArgumentReader.readShortstr(tableIn);
            switch (tableIn.readUnsignedByte()) {
                case 83: {
                    value = MethodArgumentReader.readLongstr(tableIn);
                    break;
                }
                case 73: {
                    value = tableIn.readInt();
                    break;
                }
                case 68: {
                    int scale = tableIn.readUnsignedByte();
                    byte[] unscaled = new byte[4];
                    tableIn.readFully(unscaled);
                    value = new BigDecimal(new BigInteger(unscaled), scale);
                    break;
                }
                case 84: {
                    value = MethodArgumentReader.readTimestamp(tableIn);
                    break;
                }
                case 70: {
                    value = MethodArgumentReader.readTable(tableIn);
                    break;
                }
                default: {
                    throw new MalformedFrameException("Unrecognised type in table");
                }
            }
            if (table.containsKey(name)) continue;
            table.put(name, value);
        }
        return table;
    }

    public final int readOctet() throws IOException {
        this.clearBits();
        return this.in.readUnsignedByte();
    }

    public static final Date readTimestamp(DataInputStream in) throws IOException {
        return new Date(in.readLong() * 1000L);
    }

    public final Date readTimestamp() throws IOException {
        this.clearBits();
        return MethodArgumentReader.readTimestamp(this.in);
    }
}

