/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.ContentHeader;
import com.rabbitmq.client.UnexpectedFrameError;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AMQCommand
implements Command {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int EMPTY_CONTENT_BODY_FRAME_SIZE = 8;
    private Method _method;
    private AMQContentHeader _contentHeader;
    private byte[] _body0;
    private List<byte[]> _bodyN;

    public static Assembler newAssembler() {
        return new AMQCommand().getFreshAssembler();
    }

    public AMQCommand() {
        this(null, null, null);
    }

    public AMQCommand(Method method) {
        this(method, null, null);
    }

    public AMQCommand(Method method, AMQContentHeader contentHeader, byte[] body) {
        this._method = method;
        this._contentHeader = contentHeader;
        this.setContentBody(body);
    }

    public Method getMethod() {
        return this._method;
    }

    public ContentHeader getContentHeader() {
        return this._contentHeader;
    }

    public byte[] getContentBody() {
        if (this._bodyN != null) {
            this.coalesceContentBody();
        }
        return this._body0 == null ? EMPTY_BYTE_ARRAY : this._body0;
    }

    public void setContentBody(byte[] body) {
        this._body0 = body;
        this._bodyN = null;
    }

    public void appendBodyFragment(byte[] fragment) {
        if (this._body0 == null) {
            this._body0 = fragment;
        } else {
            if (this._bodyN == null) {
                this._bodyN = new ArrayList<byte[]>();
            }
            this._bodyN.add(fragment);
        }
    }

    public void coalesceContentBody() {
        List<byte[]> oldFragments = this._bodyN;
        byte[] firstFragment = this._body0 == null ? EMPTY_BYTE_ARRAY : this._body0;
        int totalSize = firstFragment.length;
        for (byte[] fragment : oldFragments) {
            totalSize += fragment.length;
        }
        byte[] body = new byte[totalSize];
        System.arraycopy(firstFragment, 0, body, 0, firstFragment.length);
        int offset = firstFragment.length;
        for (byte[] fragment : oldFragments) {
            System.arraycopy(fragment, 0, body, offset, fragment.length);
            offset += fragment.length;
        }
        this.setContentBody(body);
    }

    public Assembler getFreshAssembler() {
        return new Assembler();
    }

    public void transmit(AMQChannel channel) throws IOException {
        int channelNumber = channel.getChannelNumber();
        AMQConnection connection = channel.getAMQConnection();
        connection.writeFrame(this._method.toFrame(channelNumber));
        if (this._method.hasContent()) {
            byte[] body = this.getContentBody();
            connection.writeFrame(this._contentHeader.toFrame(channelNumber, body.length));
            int frameMax = connection.getFrameMax();
            int bodyPayloadMax = frameMax == 0 ? body.length : frameMax - 8;
            for (int offset = 0; offset < body.length; offset += bodyPayloadMax) {
                int remaining = body.length - offset;
                int fragmentLength = remaining < bodyPayloadMax ? remaining : bodyPayloadMax;
                Frame frame = Frame.fromBodyFragment(channelNumber, body, offset, fragmentLength);
                connection.writeFrame(frame);
            }
        }
    }

    public String toString() {
        String contentStr;
        byte[] body = this.getContentBody();
        try {
            contentStr = "\"" + new String(body) + "\"";
        }
        catch (Exception e) {
            contentStr = "|" + body.length + "|";
        }
        return "{" + this._method + "," + this._contentHeader + "," + contentStr + "}";
    }

    public static void checkEmptyContentBodyFrameSize() {
        Frame f = new Frame(3, 0, new byte[0]);
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            f.writeTo(new DataOutputStream(s));
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)"IOException while checking EMPTY_CONTENT_BODY_FRAME_SIZE");
        }
        int actualLength = s.toByteArray().length;
        if (8 != actualLength) {
            throw new AssertionError((Object)("Internal error: EMPTY_CONTENT_BODY_FRAME_SIZE is incorrect - defined as 8, where the computed value is in fact " + actualLength));
        }
    }

    public class Assembler {
        public static final int STATE_EXPECTING_METHOD = 0;
        public static final int STATE_EXPECTING_CONTENT_HEADER = 1;
        public static final int STATE_EXPECTING_CONTENT_BODY = 2;
        public static final int STATE_COMPLETE = 3;
        public int state = 0;
        public long remainingBodyBytes = 0L;

        public AMQCommand completedCommand() {
            return this.state == 3 ? AMQCommand.this : null;
        }

        public void updateContentBodyState() {
            this.state = this.remainingBodyBytes > 0L ? 2 : 3;
        }

        public AMQCommand handleFrame(Frame f) throws IOException {
            switch (this.state) {
                case 0: {
                    switch (f.type) {
                        case 1: {
                            AMQCommand.this._method = AMQImpl.readMethodFrom(f.getInputStream());
                            this.state = AMQCommand.this._method.hasContent() ? 1 : 3;
                            return this.completedCommand();
                        }
                    }
                    throw new UnexpectedFrameError(f, 1);
                }
                case 1: {
                    switch (f.type) {
                        case 2: {
                            DataInputStream in = f.getInputStream();
                            AMQCommand.this._contentHeader = AMQImpl.readContentHeaderFrom(in);
                            this.remainingBodyBytes = AMQCommand.this._contentHeader.readFrom(in);
                            this.updateContentBodyState();
                            return this.completedCommand();
                        }
                    }
                    throw new UnexpectedFrameError(f, 2);
                }
                case 2: {
                    switch (f.type) {
                        case 3: {
                            byte[] fragment = f.getPayload();
                            this.remainingBodyBytes -= (long)fragment.length;
                            this.updateContentBodyState();
                            if (this.remainingBodyBytes < 0L) {
                                throw new UnsupportedOperationException("%%%%%% FIXME unimplemented");
                            }
                            AMQCommand.this.appendBodyFragment(fragment);
                            return this.completedCommand();
                        }
                    }
                    throw new UnexpectedFrameError(f, 3);
                }
            }
            throw new AssertionError((Object)("Bad Command State " + this.state));
        }
    }
}

