/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import com.r0adkll.slidr.model.SlidrPosition;

final class ScrimRenderer {
    private final View rootView;
    private final View decorView;
    private final Rect dirtyRect;

    ScrimRenderer(@NonNull View rootView, @NonNull View decorView) {
        this.rootView = rootView;
        this.decorView = decorView;
        this.dirtyRect = new Rect();
    }

    void render(Canvas canvas, SlidrPosition position, Paint paint) {
        switch (position) {
            case LEFT: {
                this.renderLeft(canvas, paint);
                break;
            }
            case RIGHT: {
                this.renderRight(canvas, paint);
                break;
            }
            case TOP: {
                this.renderTop(canvas, paint);
                break;
            }
            case BOTTOM: {
                this.renderBottom(canvas, paint);
                break;
            }
            case VERTICAL: {
                this.renderVertical(canvas, paint);
                break;
            }
            case HORIZONTAL: {
                this.renderHorizontal(canvas, paint);
            }
        }
    }

    Rect getDirtyRect(SlidrPosition position) {
        switch (position) {
            case LEFT: {
                this.dirtyRect.set(0, 0, this.decorView.getLeft(), this.rootView.getMeasuredHeight());
                break;
            }
            case RIGHT: {
                this.dirtyRect.set(this.decorView.getRight(), 0, this.rootView.getMeasuredWidth(), this.rootView.getMeasuredHeight());
                break;
            }
            case TOP: {
                this.dirtyRect.set(0, 0, this.rootView.getMeasuredWidth(), this.decorView.getTop());
                break;
            }
            case BOTTOM: {
                this.dirtyRect.set(0, this.decorView.getBottom(), this.rootView.getMeasuredWidth(), this.rootView.getMeasuredHeight());
                break;
            }
            case VERTICAL: {
                if (this.decorView.getTop() > 0) {
                    this.dirtyRect.set(0, 0, this.rootView.getMeasuredWidth(), this.decorView.getTop());
                    break;
                }
                this.dirtyRect.set(0, this.decorView.getBottom(), this.rootView.getMeasuredWidth(), this.rootView.getMeasuredHeight());
                break;
            }
            case HORIZONTAL: {
                if (this.decorView.getLeft() > 0) {
                    this.dirtyRect.set(0, 0, this.decorView.getLeft(), this.rootView.getMeasuredHeight());
                    break;
                }
                this.dirtyRect.set(this.decorView.getRight(), 0, this.rootView.getMeasuredWidth(), this.rootView.getMeasuredHeight());
            }
        }
        return this.dirtyRect;
    }

    private void renderLeft(Canvas canvas, Paint paint) {
        canvas.drawRect(0.0f, 0.0f, (float)this.decorView.getLeft(), (float)this.rootView.getMeasuredHeight(), paint);
    }

    private void renderRight(Canvas canvas, Paint paint) {
        canvas.drawRect((float)this.decorView.getRight(), 0.0f, (float)this.rootView.getMeasuredWidth(), (float)this.rootView.getMeasuredHeight(), paint);
    }

    private void renderTop(Canvas canvas, Paint paint) {
        canvas.drawRect(0.0f, 0.0f, (float)this.rootView.getMeasuredWidth(), (float)this.decorView.getTop(), paint);
    }

    private void renderBottom(Canvas canvas, Paint paint) {
        canvas.drawRect(0.0f, (float)this.decorView.getBottom(), (float)this.rootView.getMeasuredWidth(), (float)this.rootView.getMeasuredHeight(), paint);
    }

    private void renderVertical(Canvas canvas, Paint paint) {
        if (this.decorView.getTop() > 0) {
            this.renderTop(canvas, paint);
        } else {
            this.renderBottom(canvas, paint);
        }
    }

    private void renderHorizontal(Canvas canvas, Paint paint) {
        if (this.decorView.getLeft() > 0) {
            this.renderLeft(canvas, paint);
        } else {
            this.renderRight(canvas, paint);
        }
    }
}

