/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr.model;

import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import com.r0adkll.slidr.model.SlidrListener;
import com.r0adkll.slidr.model.SlidrPosition;

public class SlidrConfig {
    private int colorPrimary = -1;
    private int colorSecondary = -1;
    private float touchSize = -1.0f;
    private float sensitivity = 1.0f;
    private int scrimColor = -16777216;
    private float scrimStartAlpha = 0.8f;
    private float scrimEndAlpha = 0.0f;
    private float velocityThreshold = 5.0f;
    private float distanceThreshold = 0.25f;
    private boolean edgeOnly = false;
    private float edgeSize = 0.18f;
    private SlidrPosition position = SlidrPosition.LEFT;
    private SlidrListener listener;

    private SlidrConfig() {
    }

    public int getPrimaryColor() {
        return this.colorPrimary;
    }

    public int getSecondaryColor() {
        return this.colorSecondary;
    }

    @ColorInt
    public int getScrimColor() {
        return this.scrimColor;
    }

    public float getScrimStartAlpha() {
        return this.scrimStartAlpha;
    }

    public float getScrimEndAlpha() {
        return this.scrimEndAlpha;
    }

    public SlidrPosition getPosition() {
        return this.position;
    }

    public float getTouchSize() {
        return this.touchSize;
    }

    public float getVelocityThreshold() {
        return this.velocityThreshold;
    }

    public float getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public SlidrListener getListener() {
        return this.listener;
    }

    public boolean isEdgeOnly() {
        return this.edgeOnly;
    }

    public float getEdgeSize(float size) {
        return this.edgeSize * size;
    }

    public void setColorPrimary(int colorPrimary) {
        this.colorPrimary = colorPrimary;
    }

    public void setColorSecondary(int colorSecondary) {
        this.colorSecondary = colorSecondary;
    }

    public void setTouchSize(float touchSize) {
        this.touchSize = touchSize;
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setScrimColor(@ColorInt int scrimColor) {
        this.scrimColor = scrimColor;
    }

    public void setScrimStartAlpha(float scrimStartAlpha) {
        this.scrimStartAlpha = scrimStartAlpha;
    }

    public void setScrimEndAlpha(float scrimEndAlpha) {
        this.scrimEndAlpha = scrimEndAlpha;
    }

    public void setVelocityThreshold(float velocityThreshold) {
        this.velocityThreshold = velocityThreshold;
    }

    public void setDistanceThreshold(float distanceThreshold) {
        this.distanceThreshold = distanceThreshold;
    }

    public static class Builder {
        private SlidrConfig config = new SlidrConfig();

        public Builder primaryColor(@ColorInt int color) {
            this.config.colorPrimary = color;
            return this;
        }

        public Builder secondaryColor(@ColorInt int color) {
            this.config.colorSecondary = color;
            return this;
        }

        public Builder position(SlidrPosition position) {
            this.config.position = position;
            return this;
        }

        public Builder touchSize(float size) {
            this.config.touchSize = size;
            return this;
        }

        public Builder sensitivity(float sensitivity) {
            this.config.sensitivity = sensitivity;
            return this;
        }

        public Builder scrimColor(@ColorInt int color) {
            this.config.scrimColor = color;
            return this;
        }

        public Builder scrimStartAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.config.scrimStartAlpha = alpha;
            return this;
        }

        public Builder scrimEndAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.config.scrimEndAlpha = alpha;
            return this;
        }

        public Builder velocityThreshold(float threshold) {
            this.config.velocityThreshold = threshold;
            return this;
        }

        public Builder distanceThreshold(@FloatRange(from=0.10000000149011612, to=0.8999999761581421) float threshold) {
            this.config.distanceThreshold = threshold;
            return this;
        }

        public Builder edge(boolean flag) {
            this.config.edgeOnly = flag;
            return this;
        }

        public Builder edgeSize(@FloatRange(from=0.0, to=1.0) float edgeSize) {
            this.config.edgeSize = edgeSize;
            return this;
        }

        public Builder listener(SlidrListener listener) {
            this.config.listener = listener;
            return this;
        }

        public SlidrConfig build() {
            return this.config;
        }
    }
}

