/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr.model;

import com.r0adkll.slidr.model.SlidrPosition;

public class SlidrConfig {
    private int colorPrimary = -1;
    private int colorSecondary = -1;
    private SlidrPosition position = SlidrPosition.LEFT;
    private float touchSize = -1.0f;
    private float sensitivity = 1.0f;

    private SlidrConfig() {
    }

    public int getPrimaryColor() {
        return this.colorPrimary;
    }

    public int getSecondaryColor() {
        return this.colorSecondary;
    }

    public SlidrPosition getPosition() {
        return this.position;
    }

    public float getTouchSize() {
        return this.touchSize;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public boolean areStatusBarColorsValid() {
        return this.colorPrimary != -1 && this.colorSecondary != -1;
    }

    public static class Builder {
        private SlidrConfig config = new SlidrConfig();

        public Builder primaryColor(int color) {
            this.config.colorPrimary = color;
            return this;
        }

        public Builder secondaryColor(int color) {
            this.config.colorSecondary = color;
            return this;
        }

        public Builder position(SlidrPosition position) {
            this.config.position = position;
            return this;
        }

        public Builder touchSize(float size) {
            this.config.touchSize = size;
            return this;
        }

        public Builder sensitivity(float sensitivity) {
            this.config.sensitivity = sensitivity;
            return this;
        }

        public SlidrConfig build() {
            return this.config;
        }
    }
}

