/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.queuetoken.security;

import com.queue_it.queuetoken.TokenSerializationException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesEncryption {
    private AesEncryption() {
    }

    public static byte[] encrypt(byte[] input, String secretKey, String tokenIdentifier) throws TokenSerializationException {
        SecretKeySpec key = AesEncryption.generateKey(secretKey);
        IvParameterSpec iv = AesEncryption.generateIV(tokenIdentifier);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, iv);
            byte[] encrypted = new byte[cipher.getOutputSize(input.length)];
            int enc_len = cipher.update(input, 0, input.length, encrypted, 0);
            enc_len += cipher.doFinal(encrypted, enc_len);
            return encrypted;
        }
        catch (Exception ex) {
            throw new TokenSerializationException(ex);
        }
    }

    public static byte[] decrypt(byte[] input, String secretKey, String tokenIdentifier) throws TokenSerializationException {
        SecretKeySpec key = AesEncryption.generateKey(secretKey);
        IvParameterSpec iv = AesEncryption.generateIV(tokenIdentifier);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, iv);
            return cipher.doFinal(input);
        }
        catch (Exception ex) {
            throw new TokenSerializationException(ex);
        }
    }

    private static SecretKeySpec generateKey(String secretKey) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] keyBytes = digest.digest(secretKey.getBytes(Charset.forName(StandardCharsets.UTF_8.name())));
            return new SecretKeySpec(keyBytes, "AES");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private static IvParameterSpec generateIV(String tokenIdentifier) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] ivBytes = md5.digest(tokenIdentifier.getBytes(Charset.forName(StandardCharsets.UTF_8.name())));
            return new IvParameterSpec(ivBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }
}

