/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.mongodb.morphia;

import com.mongodb.DBRef;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.mongodb.MongodbSerializer;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.annotations.Reference;

public class MorphiaSerializer
extends MongodbSerializer {
    private final Morphia morphia;

    public MorphiaSerializer(Morphia morphia) {
        this.morphia = morphia;
    }

    @Override
    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        if (expr.getAnnotatedElement().isAnnotationPresent(Id.class)) {
            return "_id";
        }
        if (metadata.getPathType() == PathType.PROPERTY && expr.getAnnotatedElement().isAnnotationPresent(Property.class)) {
            return expr.getAnnotatedElement().getAnnotation(Property.class).value();
        }
        return super.getKeyForPath(expr, metadata);
    }

    @Override
    protected boolean isReference(Path<?> arg) {
        return arg.getAnnotatedElement().isAnnotationPresent(Reference.class);
    }

    @Override
    protected DBRef asReference(Object constant) {
        Key key = this.morphia.getMapper().getKey(constant);
        return this.morphia.getMapper().keyToRef(key);
    }
}

