/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Lists;
import com.querydsl.core.support.EnumConversion;
import com.querydsl.core.support.NumberConversion;
import com.querydsl.core.support.NumberConversions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLOps;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;

public final class Conversions {
    public static <RT> Expression<RT> convert(Expression<RT> expr) {
        if (expr instanceof FactoryExpression) {
            FactoryExpression factoryExpr = (FactoryExpression)expr;
            for (Expression e : factoryExpr.getArgs()) {
                if (!Conversions.needsNumberConversion(e)) continue;
                return new NumberConversions(factoryExpr);
            }
        } else if (Conversions.needsNumberConversion(expr)) {
            return new NumberConversion(expr);
        }
        return expr;
    }

    private static boolean needsNumberConversion(Expression<?> expr) {
        return Number.class.isAssignableFrom((expr = ExpressionUtils.extract(expr)).getType()) && !Path.class.isInstance(expr);
    }

    private static boolean isEntityPathAndNeedsWrapping(Expression<?> expr) {
        Path path;
        return (expr instanceof Path && expr.getType().isAnnotationPresent(Entity.class) || expr instanceof EntityPath && !RelationalPath.class.isInstance(expr)) && (path = (Path)expr).getMetadata().getParent() == null;
    }

    private static <RT> FactoryExpression<RT> createEntityPathConversions(FactoryExpression<RT> factoryExpr) {
        ArrayList conversions = Lists.newArrayList();
        for (Expression e : factoryExpr.getArgs()) {
            if (Conversions.isEntityPathAndNeedsWrapping(e)) {
                conversions.add(ExpressionUtils.operation((Class)e.getType(), (Operator)SQLOps.ALL, (Expression[])new Expression[]{e}));
                continue;
            }
            conversions.add(e);
        }
        return FactoryExpressionUtils.wrap(factoryExpr, (List)conversions);
    }

    public static <RT> Expression<RT> convertForNativeQuery(Expression<RT> expr) {
        if (Conversions.isEntityPathAndNeedsWrapping(expr)) {
            return ExpressionUtils.operation((Class)expr.getType(), (Operator)SQLOps.ALL, (Expression[])new Expression[]{expr});
        }
        if (Number.class.isAssignableFrom(expr.getType())) {
            return new NumberConversion(expr);
        }
        if (Enum.class.isAssignableFrom(expr.getType())) {
            return new EnumConversion(expr);
        }
        if (expr instanceof FactoryExpression) {
            NumberConversions factoryExpr = (NumberConversions)expr;
            boolean numberConversions = false;
            boolean hasEntityPath = false;
            for (Expression e : factoryExpr.getArgs()) {
                if (Conversions.isEntityPathAndNeedsWrapping(e)) {
                    hasEntityPath = true;
                    continue;
                }
                if (Number.class.isAssignableFrom(e.getType())) {
                    numberConversions = true;
                    continue;
                }
                if (!Enum.class.isAssignableFrom(e.getType())) continue;
                numberConversions = true;
            }
            if (hasEntityPath) {
                factoryExpr = Conversions.createEntityPathConversions(factoryExpr);
            }
            if (numberConversions) {
                factoryExpr = new NumberConversions(factoryExpr);
            }
            return factoryExpr;
        }
        return expr;
    }

    private Conversions() {
    }
}

