/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.dsl.Param;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.Query;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.ByteType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.Type;

public final class HibernateUtil {
    private static final Set<Class<?>> BUILT_IN = ImmutableSet.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, (Object[])new Class[]{Long.class, Short.class, String.class, BigDecimal.class, byte[].class, Byte[].class, java.util.Date.class, Calendar.class, Date.class, Time.class, Timestamp.class, Locale.class, TimeZone.class, Currency.class, Class.class, Serializable.class, Blob.class, Clob.class});
    private static final Map<Class<?>, Type> NUMERIC_TYPES;

    private HibernateUtil() {
    }

    public static void setConstants(Query query, Map<Object, String> constants, Map<ParamExpression<?>, Object> params) {
        for (Map.Entry<Object, String> entry : constants.entrySet()) {
            String key = entry.getValue();
            Object val = entry.getKey();
            if (Param.class.isInstance(val) && (val = params.get(val)) == null) {
                throw new ParamNotSetException((ParamExpression)((Param)entry.getKey()));
            }
            HibernateUtil.setValue(query, key, val);
        }
    }

    private static void setValue(Query query, String key, Object val) {
        if (val instanceof Collection) {
            query.setParameterList(key, (Collection)val);
        } else if (val instanceof Object[] && !BUILT_IN.contains(val.getClass())) {
            query.setParameterList(key, (Object[])val);
        } else if (NUMERIC_TYPES.containsKey(val.getClass())) {
            query.setParameter(key, val, NUMERIC_TYPES.get(val.getClass()));
        } else {
            query.setParameter(key, val);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Byte.class, (Object)new ByteType());
        builder.put(Short.class, (Object)new ShortType());
        builder.put(Integer.class, (Object)new IntegerType());
        builder.put(Long.class, (Object)new LongType());
        builder.put(BigInteger.class, (Object)new BigIntegerType());
        builder.put(Double.class, (Object)new DoubleType());
        builder.put(Float.class, (Object)new FloatType());
        builder.put(BigDecimal.class, (Object)new BigDecimalType());
        NUMERIC_TYPES = builder.build();
    }
}

