/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Template
implements Serializable {
    private static final long serialVersionUID = -1697705745769542204L;
    private final ImmutableList<Element> elements;
    private final String template;

    Template(String template, ImmutableList<Element> elements) {
        this.template = template;
        this.elements = elements;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public String toString() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Template) {
            return ((Template)o).template.equals(this.template);
        }
        return false;
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public static final class ByIndex
    extends Element {
        private static final long serialVersionUID = 4711323946026029998L;
        private final int index;
        private final String toString;

        public ByIndex(int index) {
            this.index = index;
            this.toString = String.valueOf(index);
        }

        @Override
        public Object convert(List<?> args) {
            Object arg = args.get(this.index);
            if (arg instanceof Expression) {
                return ExpressionUtils.extract((Expression)arg);
            }
            return arg;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isString() {
            return false;
        }

        public String toString() {
            return this.toString;
        }
    }

    public static final class Transformed
    extends Element {
        private static final long serialVersionUID = 702677732175745567L;
        private final int index;
        private final transient Function<Object, Object> transformer;
        private final String toString;

        public Transformed(int index, Function<Object, Object> transformer) {
            this.index = index;
            this.transformer = transformer;
            this.toString = String.valueOf(index);
        }

        @Override
        public Object convert(List<?> args) {
            return this.transformer.apply(args.get(this.index));
        }

        @Override
        public boolean isString() {
            return false;
        }

        public String toString() {
            return this.toString;
        }
    }

    public static final class StaticText
    extends Element {
        private static final long serialVersionUID = -2791869625053368023L;
        private final String text;
        private final String toString;

        public StaticText(String text) {
            this.text = text;
            this.toString = "'" + text + "'";
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public Object convert(List<?> args) {
            return this.text;
        }

        public String toString() {
            return this.toString;
        }
    }

    public static final class AsString
    extends Element {
        private static final long serialVersionUID = -655362047873616197L;
        private final int index;
        private final String toString;

        public AsString(int index) {
            this.index = index;
            this.toString = index + "s";
        }

        @Override
        public Object convert(List<?> args) {
            Object arg = args.get(this.index);
            return arg instanceof Constant ? arg.toString() : arg;
        }

        @Override
        public boolean isString() {
            return true;
        }

        public String toString() {
            return this.toString;
        }
    }

    @Immutable
    public static abstract class Element
    implements Serializable {
        private static final long serialVersionUID = 3396877288101929387L;

        public abstract Object convert(List<?> var1);

        public abstract boolean isString();
    }
}

