/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.qmdeve.blurview.R;
import com.qmdeve.blurview.util.Utils;
import com.qmdeve.blurview.widget.BlurView;

public class BlurButtonView
extends BlurView {
    private static final float DEFAULT_TEXT_SIZE = 16.0f;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final int DEFAULT_ICON_SIZE = 24;
    private static final int DEFAULT_ICON_PADDING = 8;
    private static final int DEFAULT_HORIZONTAL_PADDING = 16;
    private static final int DEFAULT_VERTICAL_PADDING = 12;
    private CharSequence mText;
    private TextPaint mTextPaint;
    private int mTextColor;
    private int mTextColorPressed;
    private int mTextColorDisabled;
    private float mTextSize;
    private boolean mTextBold;
    private Drawable mIcon;
    private int mIconSize;
    private int mIconPadding;
    private ColorStateList mIconTint;
    private int mGravity;
    private final Rect mTextBounds = new Rect();
    private final Rect mIconBounds = new Rect();
    private final Rect mContentBounds = new Rect();
    private View.OnClickListener mOnClickListener;
    private boolean mIsPressed = false;
    private float mButtonCornerRadius;
    private int mContentWidth = 0;
    private int mContentHeight = 0;
    private final float mPressedScale = 0.94f;
    private float mCurrentScale = 1.0f;
    private float mTargetScale = 1.0f;
    private long mAnimationStartTime = 0L;
    private boolean mIsAnimating = false;
    private final Interpolator mInterpolator = new DecelerateInterpolator();
    private boolean mIsInButtonBounds = false;
    private final int mTouchSlop;
    private float mTouchDownX;
    private float mTouchDownY;

    public BlurButtonView(Context context) {
        this(context, null);
    }

    public BlurButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.init(context, attrs);
        this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(@NonNull View v) {
                BlurButtonView.this.setFixedMargin();
            }

            public void onViewDetachedFromWindow(@NonNull View v) {
            }
        });
    }

    private void init(Context context, AttributeSet attrs) {
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = this.getResources().getDisplayMetrics().density;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BlurButtonView);
        this.mText = a.getText(R.styleable.BlurButtonView_android_text);
        this.mTextSize = a.getDimension(R.styleable.BlurButtonView_android_textSize, (float)((int)Utils.sp2px(this.getResources(), 16.0f)));
        this.mTextColor = a.getColor(R.styleable.BlurButtonView_android_textColor, -16777216);
        this.mTextColorPressed = a.getColor(R.styleable.BlurButtonView_buttonTextColorPressed, this.mTextColor);
        this.mTextColorDisabled = a.getColor(R.styleable.BlurButtonView_buttonTextColorDisabled, this.applyAlpha(this.mTextColor));
        this.mTextBold = a.getBoolean(R.styleable.BlurButtonView_buttonTextBold, true);
        this.mIcon = a.getDrawable(R.styleable.BlurButtonView_android_icon);
        this.mIconSize = a.getDimensionPixelSize(R.styleable.BlurButtonView_buttonIconSize, (int)Utils.dp2px(this.getResources(), 24.0f));
        this.mIconPadding = a.getDimensionPixelSize(R.styleable.BlurButtonView_buttonIconPadding, (int)Utils.dp2px(this.getResources(), 8.0f));
        this.mIconTint = a.getColorStateList(R.styleable.BlurButtonView_buttonIconTint);
        this.mGravity = a.getInt(R.styleable.BlurButtonView_android_gravity, 17);
        this.mButtonCornerRadius = a.getDimension(R.styleable.BlurButtonView_buttonCornerRadius, 0.0f);
        a.recycle();
        this.updateTextStyle();
        this.setClickable(true);
        this.setFocusable(true);
        this.setCornerRadius(this.mButtonCornerRadius);
        int horizontalPadding = (int)Utils.dp2px(this.getResources(), 16.0f);
        int verticalPadding = (int)Utils.dp2px(this.getResources(), 12.0f);
        this.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        this.calculateContentSize();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            int desiredWidth = this.mContentWidth + this.getPaddingLeft() + this.getPaddingRight();
            width = widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth;
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            int desiredHeight = this.mContentHeight + this.getPaddingTop() + this.getPaddingBottom();
            height = heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight;
        }
        this.setMeasuredDimension(width, height);
    }

    private void calculateContentSize() {
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            this.mTextPaint.getTextBounds(this.mText.toString(), 0, this.mText.length(), this.mTextBounds);
            textWidth = this.mTextPaint.measureText(this.mText.toString());
            Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
            textHeight = fontMetrics.descent - fontMetrics.ascent;
        }
        int iconWidth = 0;
        int iconHeight = 0;
        if (this.mIcon != null) {
            iconWidth = this.mIconSize;
            iconHeight = this.mIconSize;
        }
        this.mContentWidth = (int)textWidth + iconWidth;
        if (iconWidth > 0 && textWidth > 0.0f) {
            this.mContentWidth += this.mIconPadding;
        }
        this.mContentHeight = Math.max((int)textHeight, iconHeight);
    }

    private void updateTextStyle() {
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setFakeBoldText(this.mTextBold);
        this.updateTextColor();
    }

    private void updateTextColor() {
        if (!this.isEnabled()) {
            this.mTextPaint.setColor(this.mTextColorDisabled);
        } else if (this.mIsPressed) {
            this.mTextPaint.setColor(this.mTextColorPressed);
        } else {
            this.mTextPaint.setColor(this.mTextColor);
        }
    }

    private int applyAlpha(int color) {
        int alphaValue = Math.round((float)Color.alpha((int)color) * 0.5f);
        return Color.argb((int)alphaValue, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        this.setCornerRadius(this.mButtonCornerRadius);
        if (this.mCurrentScale != 1.0f) {
            canvas.save();
            float scale = this.mCurrentScale;
            float pivotX = (float)this.getWidth() / 2.0f;
            float pivotY = (float)this.getHeight() / 2.0f;
            canvas.scale(scale, scale, pivotX, pivotY);
            super.onDraw(canvas);
            this.drawButtonContent(canvas);
            canvas.restore();
        } else {
            super.onDraw(canvas);
            this.drawButtonContent(canvas);
        }
    }

    private void updateScaleAnimation() {
        if (!this.mIsAnimating) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        long elapsed = currentTime - this.mAnimationStartTime;
        if (elapsed >= 140L) {
            this.mCurrentScale = this.mTargetScale;
            this.mIsAnimating = false;
            this.invalidate();
            return;
        }
        float input = (float)elapsed / 140.0f;
        float interpolation = this.mInterpolator.getInterpolation(input);
        float startScale = this.mTargetScale == 0.94f ? 1.0f : 0.94f;
        float endScale = this.mTargetScale;
        this.mCurrentScale = startScale + (endScale - startScale) * interpolation;
        this.invalidate();
    }

    private void startScaleAnimation(boolean pressed) {
        this.mTargetScale = pressed ? 0.94f : 1.0f;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mIsAnimating = true;
        if (!pressed && this.mCurrentScale == 1.0f) {
            this.mIsAnimating = false;
            return;
        }
        if (pressed && this.mCurrentScale <= 0.94f) {
            this.mIsAnimating = false;
            return;
        }
        this.invalidate();
    }

    private void drawButtonContent(Canvas canvas) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.calculateContentBounds();
        this.drawIcon(canvas);
        this.drawText(canvas);
    }

    public void setButtonCornerRadius(float radius) {
        if (this.mButtonCornerRadius != radius) {
            this.mButtonCornerRadius = radius;
            this.setCornerRadius(this.mButtonCornerRadius);
            this.invalidate();
        }
    }

    private void calculateContentBounds() {
        int width = this.getWidth();
        int height = this.getHeight();
        int contentWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int contentHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        switch (this.mGravity & 7) {
            case 1: {
                left += (contentWidth - this.mContentWidth) / 2;
                break;
            }
            case 5: {
                left += contentWidth - this.mContentWidth;
                break;
            }
        }
        switch (this.mGravity & 0x70) {
            case 16: {
                top += (contentHeight - this.mContentHeight) / 2;
                break;
            }
            case 80: {
                top += contentHeight - this.mContentHeight;
                break;
            }
        }
        this.mContentBounds.set(left, top, left + this.mContentWidth, top + this.mContentHeight);
        if (this.mIcon != null) {
            int iconLeft = this.mContentBounds.left;
            int iconTop = this.mContentBounds.top + (this.mContentBounds.height() - this.mIconSize) / 2;
            this.mIconBounds.set(iconLeft, iconTop, iconLeft + this.mIconSize, iconTop + this.mIconSize);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            int textLeft = this.mContentBounds.left;
            if (this.mIcon != null) {
                textLeft += this.mIconSize + this.mIconPadding;
            }
            int textTop = this.mContentBounds.top + (this.mContentBounds.height() - this.mTextBounds.height()) / 2;
            this.mTextBounds.set(textLeft, textTop, (int)((float)textLeft + this.mTextPaint.measureText(this.mText.toString())), textTop + this.mTextBounds.height());
        }
    }

    private void drawIcon(Canvas canvas) {
        if (this.mIcon == null) {
            return;
        }
        if (this.mIconTint != null) {
            Drawable wrappedIcon = DrawableCompat.wrap((Drawable)this.mIcon.mutate());
            DrawableCompat.setTintList((Drawable)wrappedIcon, (ColorStateList)this.mIconTint);
            this.mIcon = wrappedIcon;
        }
        this.mIcon.setBounds(this.mIconBounds);
        this.mIcon.draw(canvas);
    }

    private void drawText(Canvas canvas) {
        if (TextUtils.isEmpty((CharSequence)this.mText)) {
            return;
        }
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        float textHeight = fontMetrics.descent - fontMetrics.ascent;
        float textBaseline = (float)this.mContentBounds.top + ((float)this.mContentBounds.height() - textHeight) / 2.0f - fontMetrics.ascent;
        textBaseline += Math.abs(fontMetrics.ascent) * 0.1f;
        float textLeft = this.mContentBounds.left;
        if (this.mIcon != null) {
            textLeft += (float)(this.mIconSize + this.mIconPadding);
        }
        canvas.drawText(this.mText.toString(), textLeft, textBaseline, (Paint)this.mTextPaint);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.isClickable()) {
            return super.onTouchEvent(event);
        }
        float x = event.getX();
        float y = event.getY();
        boolean isInside = x >= 0.0f && x <= (float)this.getWidth() && y >= 0.0f && y <= (float)this.getHeight();
        switch (event.getAction()) {
            case 0: {
                this.mTouchDownX = x;
                this.mTouchDownY = y;
                this.mIsInButtonBounds = true;
                this.mIsPressed = true;
                this.startScaleAnimation(true);
                this.updateTextColor();
                break;
            }
            case 2: {
                if (this.mIsInButtonBounds) {
                    float dx = Math.abs(x - this.mTouchDownX);
                    float dy = Math.abs(y - this.mTouchDownY);
                    if (!(dx > (float)this.mTouchSlop) && !(dy > (float)this.mTouchSlop)) break;
                    this.mIsInButtonBounds = isInside;
                    this.startScaleAnimation(this.mIsInButtonBounds);
                    break;
                }
                if (!isInside) break;
                this.mIsInButtonBounds = true;
                this.startScaleAnimation(true);
                break;
            }
            case 1: {
                if (this.mIsPressed && this.mIsInButtonBounds && this.mOnClickListener != null) {
                    this.mOnClickListener.onClick((View)this);
                }
                this.mIsPressed = false;
                this.mIsInButtonBounds = false;
                this.startScaleAnimation(false);
                this.updateTextColor();
                break;
            }
            case 3: {
                this.mIsPressed = false;
                this.mIsInButtonBounds = false;
                this.startScaleAnimation(false);
                this.updateTextColor();
            }
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mIsAnimating) {
            this.updateScaleAnimation();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateTextColor();
        if (!enabled) {
            this.mIsPressed = false;
            this.mIsInButtonBounds = false;
            this.startScaleAnimation(false);
        }
        this.invalidate();
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
        this.setClickable(listener != null);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.requestLayout();
    }

    public void setText(CharSequence text) {
        if (!TextUtils.equals((CharSequence)this.mText, (CharSequence)text)) {
            this.mText = text;
            this.requestLayout();
            this.invalidate();
        }
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setTextSize(float size) {
        float newSize = Utils.sp2px(this.getResources(), size);
        if (this.mTextSize != newSize) {
            this.mTextSize = newSize;
            this.mTextPaint.setTextSize(this.mTextSize);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTextColor(int color) {
        if (this.mTextColor != color) {
            this.mTextColor = color;
            this.updateTextColor();
            this.invalidate();
        }
    }

    public void setTextColorPressed(int color) {
        if (this.mTextColorPressed != color) {
            this.mTextColorPressed = color;
            this.updateTextColor();
            this.invalidate();
        }
    }

    public void setTextBold(boolean bold) {
        if (this.mTextBold != bold) {
            this.mTextBold = bold;
            this.mTextPaint.setFakeBoldText(bold);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setIcon(Drawable icon) {
        if (this.mIcon != icon) {
            this.mIcon = icon;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setIconResource(int resId) {
        this.setIcon(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)resId, (Resources.Theme)this.getContext().getTheme()));
    }

    public void setIconSize(int size) {
        int newSize = (int)Utils.dp2px(this.getResources(), size);
        if (this.mIconSize != newSize) {
            this.mIconSize = newSize;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setIconPadding(int padding) {
        int newPadding = (int)Utils.dp2px(this.getResources(), padding);
        if (this.mIconPadding != newPadding) {
            this.mIconPadding = newPadding;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setIconTint(ColorStateList tint) {
        if (this.mIconTint != tint) {
            this.mIconTint = tint;
            this.invalidate();
        }
    }

    public void setIconTintColor(int color) {
        this.setIconTint(ColorStateList.valueOf((int)color));
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.invalidate();
        }
    }

    private void setFixedMargin() {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (params instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)params;
            int fixedMargin = (int)Utils.dp2px(this.getResources(), 3.0f);
            if (marginParams.leftMargin == 0) {
                marginParams.leftMargin = fixedMargin;
            }
            if (marginParams.topMargin == 0) {
                marginParams.topMargin = fixedMargin;
            }
            if (marginParams.rightMargin == 0) {
                marginParams.rightMargin = fixedMargin;
            }
            if (marginParams.bottomMargin == 0) {
                marginParams.bottomMargin = fixedMargin;
            }
            this.setLayoutParams((ViewGroup.LayoutParams)marginParams);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setFixedMargin();
    }
}

