/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Utils {
    public static final String TAG = "BaseBlurView";
    public static boolean sIsGlobalCapturing = false;

    public static float dp2px(Resources res, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)res.getDisplayMetrics());
    }

    public static float sp2px(Resources res, float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)res.getDisplayMetrics());
    }

    public static int getNavigationBarHeight(View view) {
        WindowInsetsCompat rootWindowInsets = ViewCompat.getRootWindowInsets((View)view);
        if (rootWindowInsets != null) {
            Insets navigationBars = rootWindowInsets.getInsets(WindowInsetsCompat.Type.navigationBars());
            return navigationBars.bottom;
        }
        return 0;
    }

    public static void roundedRectPath(RectF rect, float radius, Path path) {
        path.reset();
        if (radius <= 0.0f) {
            path.addRect(rect, Path.Direction.CW);
            return;
        }
        float maxRadius = Math.min(rect.width(), rect.height()) / 2.0f;
        radius = Math.min(radius, maxRadius);
        float controlOffset = radius * 0.5522848f;
        path.moveTo(rect.left + radius, rect.top);
        path.lineTo(rect.right - radius, rect.top);
        path.cubicTo(rect.right - radius + controlOffset, rect.top, rect.right, rect.top + radius - controlOffset, rect.right, rect.top + radius);
        path.lineTo(rect.right, rect.bottom - radius);
        path.cubicTo(rect.right, rect.bottom - radius + controlOffset, rect.right - radius + controlOffset, rect.bottom, rect.right - radius, rect.bottom);
        path.lineTo(rect.left + radius, rect.bottom);
        path.cubicTo(rect.left + radius - controlOffset, rect.bottom, rect.left, rect.bottom - radius + controlOffset, rect.left, rect.bottom - radius);
        path.lineTo(rect.left, rect.top + radius);
        path.cubicTo(rect.left, rect.top + radius - controlOffset, rect.left + radius - controlOffset, rect.top, rect.left + radius, rect.top);
        path.close();
    }

    public static Bitmap ensureSoftwareBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 26 && bitmap.getConfig() == Bitmap.Config.HARDWARE) {
            Log.d((String)TAG, (String)"Converting hardware bitmap to software bitmap for blur processing");
            try {
                return bitmap.copy(Bitmap.Config.ARGB_8888, false);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Failed to convert hardware bitmap: " + e.getMessage()));
                return bitmap;
            }
        }
        return bitmap;
    }

    public static void disableHardwareBitmapsInView(View view) {
        if (view == null || Build.VERSION.SDK_INT < 26) {
            return;
        }
        try {
            BitmapDrawable bitmapDrawable;
            Bitmap bitmap;
            ImageView imageView;
            Drawable drawable;
            if (view instanceof ImageView && (drawable = (imageView = (ImageView)view).getDrawable()) instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)drawable).getBitmap()) != null && bitmap.getConfig() == Bitmap.Config.HARDWARE) {
                Log.d((String)TAG, (String)"Converting hardware bitmap in ImageView to software");
                Bitmap softwareBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
                if (softwareBitmap != null) {
                    imageView.setImageBitmap(softwareBitmap);
                }
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int childCount = viewGroup.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    Utils.disableHardwareBitmapsInView(viewGroup.getChildAt(i));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error disabling hardware bitmaps: " + e.getMessage()));
        }
    }
}

