/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.base;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.qmdeve.blurview.Blur;
import com.qmdeve.blurview.BlurNative;
import com.qmdeve.blurview.R;
import com.qmdeve.blurview.util.Utils;

public class BaseBlurViewGroup {
    private int mOverlayColor;
    private float mBlurRadius;
    private float mDownsampleFactor = 0.0f;
    private final Blur mBlur;
    private boolean mDirty = true;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private boolean mIsRendering;
    private float mCornerRadius;
    private final RectF mClipRect = new RectF();
    private final Path mG3Path = new Path();
    private View mDecorView;
    private boolean mDifferentRoot;
    private View mHostView;
    private boolean mFirstDraw = true;
    private boolean mForceRedraw = false;
    private boolean mSkipNextPreDraw = false;
    private boolean mIsPixelCopyPending = false;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private HandlerThread mPixelCopyThread;
    private Handler mPixelCopyHandler;
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            if (BaseBlurViewGroup.this.mHostView == null || !BaseBlurViewGroup.this.mHostView.isShown()) {
                return true;
            }
            if (BaseBlurViewGroup.this.mSkipNextPreDraw) {
                BaseBlurViewGroup.this.mSkipNextPreDraw = false;
                return true;
            }
            if (BaseBlurViewGroup.this.performBlurSync(BaseBlurViewGroup.this.mHostView.getWidth(), BaseBlurViewGroup.this.mHostView.getHeight())) {
                BaseBlurViewGroup.this.mHostView.postInvalidateOnAnimation();
            }
            return true;
        }
    };

    public BaseBlurViewGroup(Context context, AttributeSet attrs) {
        this.mBlur = new BlurNative();
        this.initPixelCopyThread();
        this.initAttributes(context, attrs);
    }

    private void initPixelCopyThread() {
        if (Build.VERSION.SDK_INT >= 24) {
            this.mPixelCopyThread = new HandlerThread("BlurViewGroupPixelCopy");
            this.mPixelCopyThread.start();
            this.mPixelCopyHandler = new Handler(this.mPixelCopyThread.getLooper());
        }
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BlurView);
        this.mBlurRadius = a.getDimension(R.styleable.BlurView_blurRadius, TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        this.mOverlayColor = a.getColor(R.styleable.BlurView_overlayColor, -1426063361);
        this.mCornerRadius = a.getDimension(R.styleable.BlurView_cornerRadius, 0.0f);
        this.mDownsampleFactor = a.getFloat(R.styleable.BlurView_downsampleFactor, 0.0f);
        a.recycle();
    }

    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius && radius >= 0.0f) {
            this.mBlurRadius = radius;
            this.mDirty = true;
            this.mForceRedraw = true;
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }
    }

    public void setBlurRounds(int rounds) {
        if (this.mBlur instanceof BlurNative) {
            ((BlurNative)this.mBlur).setBlurRounds(rounds);
            this.mDirty = true;
            this.mForceRedraw = true;
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }
    }

    public int getBlurRounds() {
        if (this.mBlur instanceof BlurNative) {
            return ((BlurNative)this.mBlur).getBlurRounds();
        }
        return -1;
    }

    public void setDownsampleFactor(float factor) {
        if (this.mDownsampleFactor != factor && factor >= 0.0f) {
            this.mDownsampleFactor = factor;
            this.mDirty = true;
            this.mForceRedraw = true;
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }
    }

    public void setOverlayColor(int color) {
        if (this.mOverlayColor != color) {
            this.mOverlayColor = color;
            this.mForceRedraw = true;
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }
    }

    public void setCornerRadius(float radius) {
        if (this.mCornerRadius != radius && radius >= 0.0f) {
            this.mCornerRadius = radius;
            this.mForceRedraw = true;
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public Bitmap getBlurredBitmap() {
        return this.mBlurredBitmap;
    }

    public int getOverlayColor() {
        return this.mOverlayColor;
    }

    private void releaseBitmap() {
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
        this.mBlurringCanvas = null;
    }

    public void release() {
        this.releaseBitmap();
        this.mBlur.release();
        if (this.mPixelCopyThread != null) {
            this.mPixelCopyThread.quitSafely();
            this.mPixelCopyThread = null;
            this.mPixelCopyHandler = null;
        }
    }

    private boolean prepare(int width, int height) {
        if (this.mBlurRadius <= 0.0f) {
            this.release();
            return false;
        }
        float downsampleFactor = this.mDownsampleFactor > 0.0f ? this.mDownsampleFactor : 2.52f;
        float radius = this.mBlurRadius / downsampleFactor;
        if (this.mDownsampleFactor <= 0.0f && radius > 25.0f) {
            downsampleFactor *= radius / 25.0f;
            radius = 25.0f;
        }
        if (width == 0 || height == 0) {
            return false;
        }
        int scaledWidth = Math.max(1, Math.round((float)width / downsampleFactor));
        int scaledHeight = Math.max(1, Math.round((float)height / downsampleFactor));
        boolean dirty = this.mDirty;
        if (this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
            dirty = true;
            this.releaseBitmap();
            try {
                this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
                this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBitmapToBlur = Utils.ensureSoftwareBitmap(this.mBitmapToBlur);
                this.mBlurredBitmap = Utils.ensureSoftwareBitmap(this.mBlurredBitmap);
            }
            catch (IllegalArgumentException | OutOfMemoryError e) {
                this.release();
                return false;
            }
        }
        if (dirty && this.mBlur.prepare(this.mBitmapToBlur, radius)) {
            this.mDirty = false;
        }
        return true;
    }

    private Window getActivityWindow() {
        if (this.mHostView == null) {
            return null;
        }
        Context ctx = this.mHostView.getContext();
        for (int i = 0; i < 4 && !(ctx instanceof Activity) && ctx instanceof ContextWrapper; ++i) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx instanceof Activity ? ((Activity)ctx).getWindow() : null;
    }

    private void performPixelCopyBlur(int width, int height) {
        if (this.mIsPixelCopyPending || Build.VERSION.SDK_INT < 26) {
            return;
        }
        Window window = this.getActivityWindow();
        if (window == null) {
            return;
        }
        int[] locWindow = new int[2];
        this.mHostView.getLocationInWindow(locWindow);
        Rect rect = new Rect(locWindow[0], locWindow[1], locWindow[0] + width, locWindow[1] + height);
        this.mIsPixelCopyPending = true;
        try {
            Handler handler = this.mPixelCopyHandler != null ? this.mPixelCopyHandler : this.mHandler;
            PixelCopy.request((Window)window, (Rect)rect, (Bitmap)this.mBitmapToBlur, copyResult -> this.mHandler.post(() -> {
                this.mIsPixelCopyPending = false;
                if (copyResult == 0) {
                    this.blur(this.mBitmapToBlur, this.mBlurredBitmap);
                    if (this.mHostView != null) {
                        this.mHostView.invalidate();
                    }
                } else {
                    Log.w((String)"BaseBlurView", (String)("PixelCopy fallback failed: " + copyResult));
                }
            }), (Handler)handler);
        }
        catch (IllegalArgumentException e) {
            this.mIsPixelCopyPending = false;
            Log.e((String)"BaseBlurView", (String)("PixelCopy fallback exception: " + e.getMessage()));
        }
    }

    private void blur(Bitmap input, Bitmap output) {
        try {
            Bitmap softwareInput = Utils.ensureSoftwareBitmap(input);
            this.mBlur.blur(softwareInput, output);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().contains("Software rendering doesn't support hardware bitmaps")) {
                Log.e((String)"BaseBlurView", (String)"Hardware bitmap error detected, converting and retrying");
                Bitmap softwareInput = input.copy(Bitmap.Config.ARGB_8888, false);
                Bitmap softwareOutput = output.copy(Bitmap.Config.ARGB_8888, false);
                if (softwareInput != null && softwareOutput != null) {
                    this.mBlur.blur(softwareInput, softwareOutput);
                }
                throw new RuntimeException("Failed to convert hardware bitmaps for blur processing", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performBlurSync(int width, int height) {
        block12: {
            if (this.mHostView == null) return false;
            if (this.mHostView.isShown() == false) return false;
            if (this.mDecorView == null) {
                return false;
            }
            if (!this.prepare(width, height)) {
                return false;
            }
            if (this.mBlurredBitmap == null) return false;
            if (this.mBitmapToBlur == null) return false;
            if (this.mBlurringCanvas == null) {
                return false;
            }
            locDecor = new int[2];
            locSelf = new int[2];
            this.mDecorView.getLocationOnScreen(locDecor);
            this.mHostView.getLocationOnScreen(locSelf);
            offsetX = locSelf[0] - locDecor[0];
            offsetY = locSelf[1] - locDecor[1];
            this.mBitmapToBlur.eraseColor(0);
            saveCount = this.mBlurringCanvas.save();
            this.mIsRendering = true;
            Utils.sIsGlobalCapturing = true;
            try {
                scaleX = 1.0f * (float)this.mBitmapToBlur.getWidth() / (float)width;
                scaleY = 1.0f * (float)this.mBitmapToBlur.getHeight() / (float)height;
                this.mBlurringCanvas.scale(scaleX, scaleY);
                this.mBlurringCanvas.translate((float)(-offsetX), (float)(-offsetY));
                try {
                    this.mDecorView.draw(this.mBlurringCanvas);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage() == null) throw e;
                    if (e.getMessage().contains("Software rendering doesn't support hardware bitmaps") == false) throw e;
                    Log.w((String)"BaseBlurView", (String)"Hardware bitmap detected during draw, converting and retrying");
                    Utils.disableHardwareBitmapsInView(this.mDecorView);
                    try {
                        this.mBlurringCanvas.restoreToCount(saveCount);
                        saveCount = this.mBlurringCanvas.save();
                        this.mBlurringCanvas.scale(scaleX, scaleY);
                        this.mBlurringCanvas.translate((float)(-offsetX), (float)(-offsetY));
                        this.mDecorView.draw(this.mBlurringCanvas);
                        break block12;
                    }
                    catch (Exception retryError) {
                        Log.e((String)"BaseBlurView", (String)("Retry after hardware bitmap conversion failed: " + retryError.getMessage() + ". Switching to PixelCopy fallback."));
                        if (Build.VERSION.SDK_INT >= 26) {
                            this.performPixelCopyBlur(width, height);
                            var12_12 = false;
                            this.mIsRendering = false;
                            Utils.sIsGlobalCapturing = false;
                            this.mBlurringCanvas.restoreToCount(saveCount);
                            return var12_12;
                        }
                        ** try [egrp 3[TRYBLOCK] [3 : 378->384)] { 
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block12;
                    }
lbl-1000:
                    // 1 sources

                    {
                        catch (Throwable var13_13) {
                            throw var13_13;
                        }
                    }
                }
            }
            finally {
                this.mIsRendering = false;
                Utils.sIsGlobalCapturing = false;
                this.mBlurringCanvas.restoreToCount(saveCount);
            }
        }
        this.blur(this.mBitmapToBlur, this.mBlurredBitmap);
        if (this.mDifferentRoot != false) return true;
        if (this.mForceRedraw == false) return false;
        return true;
    }

    public void ensureBlurReady(int width, int height) {
        if (this.mFirstDraw || this.mForceRedraw) {
            this.performBlurSync(width, height);
            this.mFirstDraw = false;
            this.mForceRedraw = false;
        }
    }

    private View getActivityDecorView() {
        if (this.mHostView == null) {
            return null;
        }
        Context ctx = this.mHostView.getContext();
        for (int i = 0; i < 4 && !(ctx instanceof Activity) && ctx instanceof ContextWrapper; ++i) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx instanceof Activity ? ((Activity)ctx).getWindow().getDecorView() : null;
    }

    public void onAttachedToWindow(View hostView) {
        this.mHostView = hostView;
        this.mDecorView = this.getActivityDecorView();
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
            this.mDifferentRoot = this.mDecorView.getRootView() != hostView.getRootView();
            this.mFirstDraw = true;
            this.mForceRedraw = true;
        }
    }

    public void onDetachedFromWindow() {
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
            this.mDecorView = null;
        }
        this.release();
        this.mHostView = null;
    }

    public boolean isRendering() {
        return this.mIsRendering;
    }

    public void drawBlurredBitmap(Canvas canvas, int width, int height) {
        Rect dstRect;
        this.ensureBlurReady(width, height);
        if (this.mBlurredBitmap != null) {
            Rect srcRect = new Rect(0, 0, this.mBlurredBitmap.getWidth(), this.mBlurredBitmap.getHeight());
            dstRect = new Rect(0, 0, width, height);
            if (this.mCornerRadius > 0.0f) {
                canvas.save();
                this.mClipRect.set(dstRect);
                Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
                canvas.clipPath(this.mG3Path);
                canvas.drawBitmap(this.mBlurredBitmap, srcRect, dstRect, null);
                canvas.restore();
            } else {
                canvas.drawBitmap(this.mBlurredBitmap, srcRect, dstRect, null);
            }
        }
        Paint paint = new Paint();
        paint.setColor(this.mOverlayColor);
        dstRect = new Rect(0, 0, width, height);
        if (this.mCornerRadius > 0.0f) {
            canvas.save();
            this.mClipRect.set(dstRect);
            Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
            canvas.clipPath(this.mG3Path);
            canvas.drawRect(dstRect, paint);
            canvas.restore();
        } else {
            canvas.drawRect(dstRect, paint);
        }
    }

    public void drawPreviewBackground(Canvas canvas, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        Paint previewPaint = new Paint(1);
        previewPaint.setStyle(Paint.Style.FILL);
        int previewColor = this.mOverlayColor;
        previewPaint.setColor(previewColor);
        if (this.mCornerRadius > 0.0f) {
            this.mClipRect.set(0.0f, 0.0f, (float)width, (float)height);
            Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
            canvas.drawPath(this.mG3Path, previewPaint);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, previewPaint);
        }
    }

    public void clipCanvasWithRoundedCorner(Canvas canvas, int width, int height) {
        this.mClipRect.set(0.0f, 0.0f, (float)width, (float)height);
        Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
        canvas.clipPath(this.mG3Path);
    }

    public void updateBlurImmediately() {
        if (this.mHostView != null) {
            this.mForceRedraw = true;
            this.mSkipNextPreDraw = true;
            this.mHostView.invalidate();
        }
    }
}

