/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview.base;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.PixelCopy;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.qmdeve.blurview.Blur;
import com.qmdeve.blurview.BlurNative;
import com.qmdeve.blurview.util.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class BaseBlurView
extends View {
    private static final String TAG = "BaseBlurView";
    protected int mOverlayColor;
    protected float mBlurRadius;
    protected float mDownsampleFactor = 0.0f;
    protected final Blur mBlur;
    protected boolean mDirty = true;
    protected Bitmap mBitmapToBlur;
    public Bitmap mBlurredBitmap;
    protected Canvas mBlurringCanvas;
    protected final Paint mPaint = new Paint(2);
    public final Rect mRectSrc = new Rect();
    public final Rect mRectDst = new Rect();
    public View mDecorView;
    public boolean mDifferentRoot;
    protected boolean mIsRendering;
    public float mCornerRadius;
    public final RectF mClipRect = new RectF();
    public final Path mG3Path = new Path();
    private final Map<SurfaceView, Bitmap> mSurfaceViewBitmaps = new WeakHashMap<SurfaceView, Bitmap>();
    private final Map<SurfaceView, Boolean> mPendingPixelCopies = new WeakHashMap<SurfaceView, Boolean>();
    private final Set<SurfaceView> mConfiguredSurfaceViews = Collections.newSetFromMap(new WeakHashMap());
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private HandlerThread mPixelCopyThread;
    private Handler mPixelCopyHandler;
    private boolean mFirstDraw = true;
    private boolean mForceRedraw = false;
    private boolean mSurfaceViewWarningLogged = false;
    private boolean mUsePixelCopyFallback = false;
    private boolean mIsPixelCopyPending = false;
    public final ViewTreeObserver.OnPreDrawListener preDrawListener = () -> {
        if (!this.isShown()) {
            return true;
        }
        if (this.performBlurSync()) {
            this.postInvalidateOnAnimation();
        }
        this.mForceRedraw = false;
        return true;
    };

    public BaseBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mBlur = new BlurNative();
        this.initPixelCopyThread();
        this.initAttributes(context, attrs);
    }

    private void initPixelCopyThread() {
        if (Build.VERSION.SDK_INT >= 24) {
            this.mPixelCopyThread = new HandlerThread("BlurViewPixelCopy");
            this.mPixelCopyThread.start();
            this.mPixelCopyHandler = new Handler(this.mPixelCopyThread.getLooper());
        }
    }

    protected void initAttributes(Context context, AttributeSet attrs) {
    }

    private Bitmap ensureSoftwareBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 26 && bitmap.getConfig() == Bitmap.Config.HARDWARE) {
            Log.d((String)TAG, (String)"Converting hardware bitmap to software bitmap for blur processing");
            try {
                return bitmap.copy(Bitmap.Config.ARGB_8888, false);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Failed to convert hardware bitmap: " + e.getMessage()));
                return bitmap;
            }
        }
        return bitmap;
    }

    private void disableHardwareBitmapsInView(View view) {
        if (view == null || Build.VERSION.SDK_INT < 26) {
            return;
        }
        try {
            BitmapDrawable bitmapDrawable;
            Bitmap bitmap;
            ImageView imageView;
            Drawable drawable;
            if (view instanceof ImageView && (drawable = (imageView = (ImageView)view).getDrawable()) instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)drawable).getBitmap()) != null && bitmap.getConfig() == Bitmap.Config.HARDWARE) {
                Log.d((String)TAG, (String)"Converting hardware bitmap in ImageView to software");
                Bitmap softwareBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
                if (softwareBitmap != null) {
                    imageView.setImageBitmap(softwareBitmap);
                }
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int childCount = viewGroup.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    this.disableHardwareBitmapsInView(viewGroup.getChildAt(i));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error disabling hardware bitmaps: " + e.getMessage()));
        }
    }

    private void drawTextureViews(View view, Canvas canvas) {
        block3: {
            block2: {
                if (!(view instanceof TextureView)) break block2;
                TextureView textureView = (TextureView)view;
                if (textureView.getVisibility() != 0 || !textureView.isAvailable()) break block3;
                int[] locDecor = new int[2];
                this.mDecorView.getLocationOnScreen(locDecor);
                int[] locTexture = new int[2];
                textureView.getLocationOnScreen(locTexture);
                int left = locTexture[0] - locDecor[0];
                int top = locTexture[1] - locDecor[1];
                Bitmap bitmap = textureView.getBitmap();
                if (bitmap == null) break block3;
                bitmap = this.ensureSoftwareBitmap(bitmap);
                canvas.save();
                canvas.translate((float)left, (float)top);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                canvas.restore();
                bitmap.recycle();
                break block3;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    this.drawTextureViews(group.getChildAt(i), canvas);
                }
            }
        }
    }

    private void drawSurfaceViews(View view, Canvas canvas) {
        block14: {
            block13: {
                Bitmap cachedBitmap;
                if (!(view instanceof SurfaceView)) break block13;
                SurfaceView surfaceView = (SurfaceView)view;
                if (surfaceView.getVisibility() != 0) break block14;
                if (!this.mConfiguredSurfaceViews.contains(surfaceView)) {
                    try {
                        surfaceView.setZOrderMediaOverlay(true);
                        Log.i((String)TAG, (String)"Automatically configured SurfaceView with setZOrderMediaOverlay(true) for proper blur rendering");
                        this.mConfiguredSurfaceViews.add(surfaceView);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)("Failed to auto-configure SurfaceView: " + e.getMessage()));
                    }
                }
                if (!this.mSurfaceViewWarningLogged) {
                    if (Build.VERSION.SDK_INT < 24) {
                        Log.w((String)TAG, (String)("SurfaceView blur requires Android 7.0+ (API 24). Current API level: " + Build.VERSION.SDK_INT + ". SurfaceView content will NOT be blurred. Consider using TextureView instead."));
                    } else {
                        Log.i((String)TAG, (String)"SurfaceView detected and automatically configured for blur. Note: There may be a slight lag (1-2 frames) due to asynchronous PixelCopy.");
                    }
                    this.mSurfaceViewWarningLogged = true;
                }
                if ((cachedBitmap = this.mSurfaceViewBitmaps.get(surfaceView)) != null && !cachedBitmap.isRecycled()) {
                    int[] locDecor = new int[2];
                    this.mDecorView.getLocationOnScreen(locDecor);
                    int[] locSurface = new int[2];
                    surfaceView.getLocationOnScreen(locSurface);
                    int left = locSurface[0] - locDecor[0];
                    int top = locSurface[1] - locDecor[1];
                    canvas.save();
                    canvas.translate((float)left, (float)top);
                    canvas.drawBitmap(cachedBitmap, 0.0f, 0.0f, null);
                    canvas.restore();
                }
                if (Build.VERSION.SDK_INT < 24 || Boolean.TRUE.equals(this.mPendingPixelCopies.get(surfaceView)) || surfaceView.getWidth() <= 0 || surfaceView.getHeight() <= 0) break block14;
                if (surfaceView.getHolder().getSurface() != null && surfaceView.getHolder().getSurface().isValid()) {
                    Bitmap bitmap = Bitmap.createBitmap((int)surfaceView.getWidth(), (int)surfaceView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    this.mPendingPixelCopies.put(surfaceView, true);
                    try {
                        Handler handler = this.mPixelCopyHandler != null ? this.mPixelCopyHandler : this.mHandler;
                        PixelCopy.request((SurfaceView)surfaceView, (Bitmap)bitmap, copyResult -> this.mHandler.post(() -> {
                            this.mPendingPixelCopies.put(surfaceView, false);
                            if (copyResult == 0) {
                                Bitmap old = this.mSurfaceViewBitmaps.put(surfaceView, bitmap);
                                if (old != null) {
                                    old.recycle();
                                }
                                this.invalidate();
                            } else {
                                Log.w((String)TAG, (String)("PixelCopy failed. Result: " + copyResult));
                                if (copyResult == 3 || copyResult == 1 || copyResult == 2) {
                                    this.postInvalidateDelayed(100L);
                                }
                                bitmap.recycle();
                            }
                        }), (Handler)handler);
                    }
                    catch (IllegalArgumentException e) {
                        Log.e((String)TAG, (String)("PixelCopy request failed: " + e.getMessage() + ". Make sure surfaceView.setZOrderMediaOverlay(true) is called."));
                        this.mPendingPixelCopies.put(surfaceView, false);
                        bitmap.recycle();
                    }
                } else {
                    this.postInvalidateDelayed(100L);
                }
                break block14;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    this.drawSurfaceViews(group.getChildAt(i), canvas);
                }
            }
        }
    }

    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius && radius >= 0.0f) {
            this.mBlurRadius = radius;
            this.mDirty = true;
            this.mForceRedraw = true;
            this.invalidate();
        }
    }

    public void setBlurRounds(int rounds) {
        if (this.mBlur instanceof BlurNative) {
            ((BlurNative)this.mBlur).setBlurRounds(rounds);
            this.mDirty = true;
            this.mForceRedraw = true;
            this.invalidate();
        }
    }

    public int getBlurRounds() {
        if (this.mBlur instanceof BlurNative) {
            return ((BlurNative)this.mBlur).getBlurRounds();
        }
        return -1;
    }

    public void setDownsampleFactor(float factor) {
        if (this.mDownsampleFactor != factor && factor >= 0.0f) {
            this.mDownsampleFactor = factor;
            this.mDirty = true;
            this.mForceRedraw = true;
            this.invalidate();
        }
    }

    public void setOverlayColor(int color) {
        if (this.mOverlayColor != color) {
            this.mOverlayColor = color;
            this.mForceRedraw = true;
            this.invalidate();
        }
    }

    public void setCornerRadius(float radius) {
        if (this.mCornerRadius != radius && radius >= 0.0f) {
            this.mCornerRadius = radius;
            this.mForceRedraw = true;
            this.invalidate();
        }
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public Bitmap getBlurredBitmap() {
        return this.mBlurredBitmap;
    }

    public int getOverlayColor() {
        return this.mOverlayColor;
    }

    protected void releaseBitmap() {
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
        this.mBlurringCanvas = null;
    }

    public void release() {
        this.releaseBitmap();
        this.mBlur.release();
        if (this.mPixelCopyThread != null) {
            this.mPixelCopyThread.quitSafely();
            this.mPixelCopyThread = null;
            this.mPixelCopyHandler = null;
        }
    }

    protected boolean prepare() {
        if (this.mBlurRadius <= 0.0f) {
            this.release();
            return false;
        }
        float downsampleFactor = this.mDownsampleFactor > 0.0f ? this.mDownsampleFactor : 2.52f;
        float radius = this.mBlurRadius / downsampleFactor;
        if (this.mDownsampleFactor <= 0.0f && radius > 25.0f) {
            downsampleFactor *= radius / 25.0f;
            radius = 25.0f;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0 || height == 0) {
            return false;
        }
        int scaledWidth = Math.max(1, Math.round((float)width / downsampleFactor));
        int scaledHeight = Math.max(1, Math.round((float)height / downsampleFactor));
        boolean dirty = this.mDirty;
        if (this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
            dirty = true;
            this.releaseBitmap();
            try {
                this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
                this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBitmapToBlur = Utils.ensureSoftwareBitmap(this.mBitmapToBlur);
                this.mBlurredBitmap = Utils.ensureSoftwareBitmap(this.mBlurredBitmap);
            }
            catch (OutOfMemoryError e) {
                this.release();
                return false;
            }
        }
        if (dirty && this.mBlur.prepare(this.mBitmapToBlur, radius)) {
            this.mDirty = false;
        }
        return true;
    }

    protected void blur(Bitmap input, Bitmap output) {
        try {
            Bitmap softwareInput = Utils.ensureSoftwareBitmap(input);
            this.mBlur.blur(softwareInput, output);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().contains("Software rendering doesn't support hardware bitmaps")) {
                Log.e((String)TAG, (String)"Hardware bitmap error detected, converting and retrying");
                Bitmap softwareInput = input.copy(Bitmap.Config.ARGB_8888, false);
                Bitmap softwareOutput = output.copy(Bitmap.Config.ARGB_8888, false);
                if (softwareInput != null && softwareOutput != null) {
                    this.mBlur.blur(softwareInput, softwareOutput);
                }
                throw new RuntimeException("Failed to convert hardware bitmaps for blur processing", e);
            }
            throw e;
        }
    }

    private void performPixelCopyBlur() {
        if (this.mIsPixelCopyPending || Build.VERSION.SDK_INT < 26) {
            return;
        }
        Window window = this.getActivityWindow();
        if (window == null) {
            return;
        }
        int[] locWindow = new int[2];
        this.getLocationInWindow(locWindow);
        Rect rect = new Rect(locWindow[0], locWindow[1], locWindow[0] + this.getWidth(), locWindow[1] + this.getHeight());
        this.mIsPixelCopyPending = true;
        try {
            Handler handler = this.mPixelCopyHandler != null ? this.mPixelCopyHandler : this.mHandler;
            PixelCopy.request((Window)window, (Rect)rect, (Bitmap)this.mBitmapToBlur, copyResult -> this.mHandler.post(() -> {
                this.mIsPixelCopyPending = false;
                if (copyResult == 0) {
                    this.blur(this.mBitmapToBlur, this.mBlurredBitmap);
                    this.invalidate();
                } else {
                    Log.w((String)TAG, (String)("PixelCopy fallback failed: " + copyResult));
                }
            }), (Handler)handler);
        }
        catch (IllegalArgumentException e) {
            this.mIsPixelCopyPending = false;
            Log.e((String)TAG, (String)("PixelCopy fallback exception: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean performBlurSync() {
        if (this.isShown() == false) return false;
        if (this.mDecorView == null) {
            return false;
        }
        old = this.mBlurredBitmap;
        if (!this.prepare()) {
            return false;
        }
        v0 = redrawBitmap = this.mBlurredBitmap != old;
        if (this.mUsePixelCopyFallback && Build.VERSION.SDK_INT >= 26) {
            this.performPixelCopyBlur();
            if (redrawBitmap != false) return true;
            if (this.mDifferentRoot != false) return true;
            if (this.mForceRedraw == false) return false;
            return true;
        }
        locDecor = new int[2];
        locSelf = new int[2];
        this.mDecorView.getLocationOnScreen(locDecor);
        this.getLocationOnScreen(locSelf);
        offsetX = locSelf[0] - locDecor[0];
        offsetY = locSelf[1] - locDecor[1];
        this.mBitmapToBlur.eraseColor(0);
        saveCount = this.mBlurringCanvas.save();
        this.mIsRendering = true;
        Utils.sIsGlobalCapturing = true;
        try {
            scaleX = 1.0f * (float)this.mBitmapToBlur.getWidth() / (float)this.getWidth();
            scaleY = 1.0f * (float)this.mBitmapToBlur.getHeight() / (float)this.getHeight();
            this.mBlurringCanvas.scale(scaleX, scaleY);
            this.mBlurringCanvas.translate((float)(-offsetX), (float)(-offsetY));
            try {
                this.mDecorView.draw(this.mBlurringCanvas);
                ** GOTO lbl-1000
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() == null) throw e;
                if (e.getMessage().contains("Software rendering doesn't support hardware bitmaps") == false) throw e;
                Log.w((String)"BaseBlurView", (String)"Hardware bitmap detected during draw, converting and retrying");
                Utils.disableHardwareBitmapsInView(this.mDecorView);
                try {
                    this.mBlurringCanvas.restoreToCount(saveCount);
                    saveCount = this.mBlurringCanvas.save();
                    this.mBlurringCanvas.scale(scaleX, scaleY);
                    this.mBlurringCanvas.translate((float)(-offsetX), (float)(-offsetY));
                    this.mDecorView.draw(this.mBlurringCanvas);
                }
                catch (Exception retryError) {
                    Log.e((String)"BaseBlurView", (String)("Retry after hardware bitmap conversion failed: " + retryError.getMessage() + ". Switching to PixelCopy fallback."));
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.mUsePixelCopyFallback = true;
                        this.performPixelCopyBlur();
                        var12_12 = false;
                        this.mIsRendering = false;
                        Utils.sIsGlobalCapturing = false;
                        this.mBlurringCanvas.restoreToCount(saveCount);
                        return var12_12;
                    }
                    this.drawTextureViews(this.mDecorView, this.mBlurringCanvas);
                    this.drawSurfaceViews(this.mDecorView, this.mBlurringCanvas);
                }
            }
        }
        finally {
            this.mIsRendering = false;
            Utils.sIsGlobalCapturing = false;
            this.mBlurringCanvas.restoreToCount(saveCount);
        }
        this.blur(this.mBitmapToBlur, this.mBlurredBitmap);
        if (redrawBitmap != false) return true;
        if (this.mDifferentRoot != false) return true;
        if (this.mForceRedraw == false) return false;
        return true;
    }

    public View getActivityDecorView() {
        Context ctx = this.getContext();
        for (int i = 0; i < 4 && !(ctx instanceof Activity) && ctx instanceof ContextWrapper; ++i) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx instanceof Activity ? ((Activity)ctx).getWindow().getDecorView() : null;
    }

    private Window getActivityWindow() {
        Context ctx = this.getContext();
        for (int i = 0; i < 4 && !(ctx instanceof Activity) && ctx instanceof ContextWrapper; ++i) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx instanceof Activity ? ((Activity)ctx).getWindow() : null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mDecorView = this.getActivityDecorView();
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
            this.mDifferentRoot = this.mDecorView.getRootView() != this.getRootView();
            this.mFirstDraw = true;
            this.mForceRedraw = true;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
            this.mDecorView = null;
        }
        this.release();
        super.onDetachedFromWindow();
    }

    public void draw(@NonNull Canvas canvas) {
        if (!this.mIsRendering) {
            if (this.mFirstDraw || this.mForceRedraw) {
                this.performBlurSync();
                this.mFirstDraw = false;
                this.mForceRedraw = false;
            }
            super.draw(canvas);
        }
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        this.drawBlurredBitmap(canvas);
    }

    public void drawBlurredBitmap(Canvas canvas) {
        if (Utils.sIsGlobalCapturing && !this.mIsRendering) {
            return;
        }
        if (this.mBlurredBitmap != null) {
            this.mRectSrc.set(0, 0, this.mBlurredBitmap.getWidth(), this.mBlurredBitmap.getHeight());
            this.mRectDst.set(0, 0, this.getWidth(), this.getHeight());
            if (this.mCornerRadius > 0.0f) {
                canvas.save();
                this.mClipRect.set(this.mRectDst);
                Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
                canvas.clipPath(this.mG3Path);
                canvas.drawBitmap(this.mBlurredBitmap, this.mRectSrc, this.mRectDst, null);
                canvas.restore();
            } else {
                canvas.drawBitmap(this.mBlurredBitmap, this.mRectSrc, this.mRectDst, null);
            }
        }
        this.mPaint.setColor(this.mOverlayColor);
        if (this.mCornerRadius > 0.0f) {
            canvas.save();
            this.mClipRect.set(this.mRectDst);
            Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
            canvas.clipPath(this.mG3Path);
            canvas.drawRect(this.mRectDst, this.mPaint);
            canvas.restore();
        } else {
            canvas.drawRect(this.mRectDst, this.mPaint);
        }
    }

    public void drawPreviewBackground(Canvas canvas) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Paint previewPaint = new Paint(1);
        previewPaint.setStyle(Paint.Style.FILL);
        int previewColor = this.mOverlayColor;
        previewPaint.setColor(previewColor);
        if (this.mCornerRadius > 0.0f) {
            this.mClipRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            Utils.roundedRectPath(this.mClipRect, this.mCornerRadius, this.mG3Path);
            canvas.drawPath(this.mG3Path, previewPaint);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), previewPaint);
        }
    }

    public boolean isInEditMode() {
        return super.isInEditMode();
    }
}

