/*
 * Decompiled with CFR 0.152.
 */
package com.qmdeve.blurview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.qmdeve.blurview.Blur;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class BlurNative
implements Blur {
    private static final int MAX_RADIUS = 100;
    private static final int MIN_RADIUS = 2;
    private static final int THREAD_COUNT;
    private static final ExecutorService EXECUTOR;
    private final AtomicBoolean isBlurring = new AtomicBoolean(false);
    private float radius = 100.0f;
    private int blurRounds = 2;
    private static Boolean DEBUG;

    public static native void blur(Object var0, int var1, int var2, int var3, int var4);

    @Override
    public boolean prepare(Bitmap buffer, float radius) {
        this.radius = BlurNative.clamp(radius);
        return true;
    }

    public void setBlurRounds(int rounds) {
        this.blurRounds = Math.max(1, Math.min(15, rounds));
    }

    public int getBlurRounds() {
        return this.blurRounds;
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blur(Bitmap input, Bitmap output) {
        if (input == null || output == null || input.isRecycled() || output.isRecycled()) {
            return;
        }
        if (!this.isBlurring.compareAndSet(false, true)) {
            return;
        }
        try {
            if (input != output) {
                output.eraseColor(0);
                new Canvas(output).drawBitmap(input, 0.0f, 0.0f, null);
            }
            for (int iteration = 0; iteration < this.blurRounds; ++iteration) {
                this.doBlurRound(output, 1);
                this.doBlurRound(output, 2);
            }
        }
        catch (Exception e) {
            if (Boolean.TRUE.equals(DEBUG)) {
                e.printStackTrace();
            }
        }
        finally {
            this.isBlurring.set(false);
        }
    }

    private void doBlurRound(Bitmap bitmap, int round) {
        int r = (int)this.radius;
        if (THREAD_COUNT == 1) {
            BlurNative.blur(bitmap, r, 1, 0, round);
            return;
        }
        CountDownLatch latch = new CountDownLatch(THREAD_COUNT);
        int i = 0;
        while (i < THREAD_COUNT) {
            int index = i++;
            EXECUTOR.execute(() -> {
                try {
                    BlurNative.blur(bitmap, r, THREAD_COUNT, index, round);
                }
                catch (Exception e) {
                    if (Boolean.TRUE.equals(DEBUG)) {
                        e.printStackTrace();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static float clamp(float value) {
        return Math.max(2.0f, Math.min(100.0f, value));
    }

    static boolean isDebug(Context ctx) {
        if (DEBUG == null && ctx != null) {
            DEBUG = (ctx.getApplicationInfo().flags & 2) != 0;
        }
        return Boolean.TRUE.equals(DEBUG);
    }

    static {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        THREAD_COUNT = Math.max(2, Math.min(5, cpuCount));
        EXECUTOR = Executors.newFixedThreadPool(THREAD_COUNT, r -> {
            Thread t = new Thread(r, "NativeBlurThread");
            t.setPriority(1);
            t.setDaemon(true);
            return t;
        });
        System.loadLibrary("QmBlur");
        DEBUG = null;
    }
}

