/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import com.qiniu.android.utils.UrlSafeBase64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import org.json.JSONObject;

public final class StringUtils {
    private StringUtils() {
    }

    public static String join(String[] array, String sep) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int sepSize = 0;
        if (sep != null && !sep.equals("")) {
            sepSize = sep.length();
        }
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].length()) + sepSize) * arraySize;
        StringBuilder buf = new StringBuilder(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String jsonJoin(String[] array) {
        int arraySize = array.length;
        if (array[0] == null) {
            array[0] = "";
        }
        int bufSize = arraySize * (array[0].length() + 3);
        StringBuilder buf = new StringBuilder(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append('\"');
            buf.append(array[i]);
            buf.append('\"');
        }
        return buf.toString();
    }

    public static String jsonJoin(Long[] array) {
        return StringUtils.jsonJoin(StringUtils.longToString(array));
    }

    public static String[] longToString(Long[] longArray) {
        String[] stringArray = new String[longArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray[i] = String.valueOf(longArray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                stringArray[i] = "null";
            }
        }
        return stringArray;
    }

    public static byte[] utf8Bytes(String data) {
        try {
            return data.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static String toNonnullString(Object s) {
        return s == null ? "" : "" + s;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().equals("");
    }

    public static String strip(String s) {
        StringBuilder b = new StringBuilder();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c <= '\u001f' || c >= '\u007f') continue;
            b.append(c);
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] bytes) {
        Object obj = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static String getAkAndScope(String token) {
        String[] strings = token.split(":");
        String ak = strings[0];
        String policy = null;
        try {
            policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
            JSONObject obj = new JSONObject(policy);
            String scope = obj.getString("scope");
            String bkt = scope.split(":")[0];
            return ak + bkt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getBucket(String token) {
        String[] strings = token.split(":");
        String policy = null;
        try {
            policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
            JSONObject obj = new JSONObject(policy);
            String scope = obj.getString("scope");
            String bkt = scope.split(":")[0];
            return bkt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String upperCase(String str) {
        if (str.length() <= 0 || str == null) {
            return "";
        }
        char[] ch = str.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }
}

