/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.transaction;

import com.qiniu.android.utils.Utils;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TransactionManager {
    protected final ConcurrentLinkedQueue<Transaction> transactionList = new ConcurrentLinkedQueue();
    private Timer timer;
    protected long actionCount = 0L;
    private static final TransactionManager transactionManager = new TransactionManager();

    private TransactionManager() {
    }

    public static TransactionManager getInstance() {
        return transactionManager;
    }

    public ArrayList<Transaction> transactionsForName(String name) {
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        for (Transaction transaction : this.transactionList) {
            if ((name != null || transaction.name != null) && (transaction.name == null || !transaction.name.equals(name))) continue;
            arrayList.add(transaction);
        }
        return arrayList;
    }

    public boolean existTransactionsForName(String name) {
        boolean isExist = false;
        for (Transaction transaction : this.transactionList) {
            if ((name != null || transaction.name != null) && (transaction.name == null || !transaction.name.equals(name))) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public void addTransaction(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        this.transactionList.add(transaction);
        this.createTimer();
    }

    public void removeTransaction(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        this.transactionList.remove(transaction);
    }

    public synchronized void performTransaction(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        if (!this.transactionList.contains(transaction)) {
            this.transactionList.add(transaction);
        }
        transaction.nextExecutionTime = Utils.currentSecondTimestamp();
    }

    public synchronized void destroyResource() {
        this.invalidateTimer();
        this.transactionList.clear();
    }

    private void handleAllTransaction() {
        for (Transaction transaction : this.transactionList) {
            this.handleTransaction(transaction);
            if (!transaction.maybeCompleted()) continue;
            this.removeTransaction(transaction);
        }
    }

    private void handleTransaction(Transaction transaction) {
        transaction.handleAction();
    }

    private synchronized void createTimer() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TransactionManager.this.timerAction();
            }
        }, 0L, 1000L);
    }

    private void invalidateTimer() {
        this.timer.cancel();
        this.timer = null;
    }

    private void timerAction() {
        ++this.actionCount;
        this.handleAllTransaction();
    }

    public static class Transaction {
        public final String name;
        public final int after;
        public final Runnable actionHandler;
        private static final int TransactionTypeNormal = 0;
        private static final int TransactionTypeTime = 1;
        private final int type;
        private final int interval;
        private long createTime;
        protected long nextExecutionTime;
        protected long executedCount = 0L;
        private boolean isExecuting = false;

        public Transaction(String name, int after, Runnable actionHandler) {
            this.type = 0;
            this.name = name;
            this.after = after;
            this.interval = 0;
            this.actionHandler = actionHandler;
            this.createTime = Utils.currentSecondTimestamp();
            this.nextExecutionTime = this.createTime + (long)after;
        }

        public Transaction(String name, int after, int interval, Runnable actionHandler) {
            this.type = 1;
            this.name = name;
            this.after = after;
            this.interval = interval;
            this.actionHandler = actionHandler;
            this.createTime = Utils.currentSecondTimestamp();
            this.nextExecutionTime = this.createTime + (long)after;
        }

        protected boolean shouldAction() {
            long currentTime = Utils.currentSecondTimestamp();
            if (this.type == 0) {
                return this.executedCount < 1L && currentTime >= this.nextExecutionTime;
            }
            if (this.type == 1) {
                return currentTime >= this.nextExecutionTime;
            }
            return false;
        }

        protected boolean maybeCompleted() {
            if (this.type == 0) {
                return this.executedCount > 0L;
            }
            if (this.type == 1) {
                return false;
            }
            return false;
        }

        private synchronized void handleAction() {
            if (!this.shouldAction()) {
                return;
            }
            if (this.actionHandler != null) {
                this.isExecuting = true;
                ++this.executedCount;
                try {
                    this.actionHandler.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.nextExecutionTime = Utils.currentSecondTimestamp() + (long)this.interval;
                this.isExecuting = false;
            }
        }

        public boolean isExecuting() {
            return this.isExecuting;
        }
    }
}

