/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.AutoZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.http.ProxyConfiguration;
import com.qiniu.android.http.UrlConverter;
import com.qiniu.android.http.request.IRequestClient;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import java.io.File;

public final class Configuration {
    public static int RESUME_UPLOAD_VERSION_V1 = 0;
    public static int RESUME_UPLOAD_VERSION_V2 = 1;
    public final Zone zone;
    public static final int BLOCK_SIZE = 0x400000;
    public final int chunkSize;
    public final int putThreshold;
    public final int retryMax;
    public final int retryInterval;
    public final int connectTimeout;
    public final int writeTimeout;
    public final int responseTimeout;
    public final boolean useHttps;
    public final boolean useConcurrentResumeUpload;
    public final int resumeUploadVersion;
    public final int concurrentTaskCount;
    public final boolean accelerateUploading;
    public final boolean allowBackupHost;
    public final Recorder recorder;
    public final KeyGenerator keyGen;
    public final ProxyConfiguration proxy;
    public final UrlConverter urlConverter;
    public final IRequestClient requestClient;

    private Configuration(Builder builder) {
        this.requestClient = builder.requestClient;
        this.useConcurrentResumeUpload = builder.useConcurrentResumeUpload;
        this.resumeUploadVersion = builder.resumeUploadVersion;
        this.concurrentTaskCount = builder.concurrentTaskCount;
        if (builder.resumeUploadVersion == RESUME_UPLOAD_VERSION_V1) {
            if (builder.chunkSize < 1024) {
                builder.chunkSize = 1024;
            }
        } else if (builder.resumeUploadVersion == RESUME_UPLOAD_VERSION_V2 && builder.chunkSize < 0x100000) {
            builder.chunkSize = 0x100000;
        }
        this.chunkSize = builder.chunkSize;
        this.putThreshold = builder.putThreshold;
        this.connectTimeout = builder.connectTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.responseTimeout = builder.responseTimeout;
        this.recorder = builder.recorder;
        this.keyGen = this.getKeyGen(builder.keyGen);
        this.retryMax = builder.retryMax;
        this.retryInterval = builder.retryInterval;
        this.allowBackupHost = builder.allowBackupHost;
        this.accelerateUploading = builder.accelerateUploading;
        this.proxy = builder.proxy;
        this.urlConverter = builder.urlConverter;
        this.useHttps = builder.useHttps;
        this.zone = builder.zone != null ? builder.zone : new AutoZone();
    }

    private KeyGenerator getKeyGen(KeyGenerator keyGen) {
        if (keyGen == null) {
            keyGen = new KeyGenerator(){

                @Override
                public String gen(String key, File file) {
                    return key + "_._" + new StringBuffer(file.getAbsolutePath()).reverse();
                }

                @Override
                public String gen(String key, String sourceId) {
                    if (sourceId == null) {
                        sourceId = "";
                    }
                    return key + "_._" + sourceId;
                }
            };
        }
        return keyGen;
    }

    public static class Builder {
        private IRequestClient requestClient = null;
        private Zone zone = null;
        private Recorder recorder = null;
        private KeyGenerator keyGen = null;
        private ProxyConfiguration proxy = null;
        private boolean useHttps = true;
        private int chunkSize = 0x200000;
        private int putThreshold = 0x400000;
        private int connectTimeout = 10;
        private int writeTimeout = 30;
        private int responseTimeout = 10;
        private int retryMax = 1;
        private int retryInterval = 500;
        private boolean accelerateUploading = false;
        private boolean allowBackupHost = true;
        private UrlConverter urlConverter = null;
        private boolean useConcurrentResumeUpload = false;
        private int resumeUploadVersion = RESUME_UPLOAD_VERSION_V1;
        private int concurrentTaskCount = 3;

        public Builder requestClient(IRequestClient requestClient) {
            this.requestClient = requestClient;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder recorder(Recorder recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder recorder(Recorder recorder, KeyGenerator keyGen) {
            this.recorder = recorder;
            this.keyGen = keyGen;
            return this;
        }

        public Builder proxy(ProxyConfiguration proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder chunkSize(int size) {
            this.chunkSize = size;
            return this;
        }

        public Builder putThreshold(int size) {
            this.putThreshold = size;
            return this;
        }

        public Builder connectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder writeTimeout(int timeout) {
            this.writeTimeout = timeout;
            return this;
        }

        public Builder responseTimeout(int timeout) {
            this.responseTimeout = timeout;
            return this;
        }

        public Builder retryMax(int times) {
            this.retryMax = times;
            return this;
        }

        public Builder retryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder accelerateUploading(boolean isAllow) {
            this.accelerateUploading = isAllow;
            return this;
        }

        public Builder allowBackupHost(boolean isAllow) {
            this.allowBackupHost = isAllow;
            return this;
        }

        public Builder urlConverter(UrlConverter converter) {
            this.urlConverter = converter;
            return this;
        }

        public Builder useConcurrentResumeUpload(boolean useConcurrentResumeUpload) {
            this.useConcurrentResumeUpload = useConcurrentResumeUpload;
            return this;
        }

        public Builder resumeUploadVersion(int resumeUploadVersion) {
            this.resumeUploadVersion = resumeUploadVersion;
            return this;
        }

        public Builder concurrentTaskCount(int concurrentTaskCount) {
            this.concurrentTaskCount = concurrentTaskCount;
            return this;
        }

        public Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

