/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.metrics.UploadTaskMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.serverRegion.UploadDomainRegion;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.ListUtils;
import java.util.ArrayList;
import org.json.JSONObject;

abstract class BaseUpload
implements Runnable {
    protected final String key;
    protected final String fileName;
    protected final byte[] data;
    protected final UploadSource uploadSource;
    protected final UpToken token;
    protected final UploadOptions option;
    protected final Configuration config;
    protected final Recorder recorder;
    protected final String recorderKey;
    protected final UpTaskCompletionHandler completionHandler;
    private UploadRegionRequestMetrics currentRegionRequestMetrics;
    private UploadTaskMetrics metrics;
    private int currentRegionIndex;
    private ArrayList<IUploadRegion> regions;
    protected static final String UploadUpTypeForm = "form";
    protected static final String UploadUpTypeResumableV1 = "resumable_v1";
    protected static final String UploadUpTypeResumableV2 = "resumable_v2";

    private BaseUpload(UploadSource source, byte[] data, String fileName, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, UpTaskCompletionHandler completionHandler) {
        this.uploadSource = source;
        this.data = data;
        this.fileName = fileName != null ? fileName : "?";
        this.key = key;
        this.token = token;
        this.option = option != null ? option : UploadOptions.defaultOptions();
        this.config = config;
        this.recorder = recorder;
        this.recorderKey = recorderKey;
        this.completionHandler = completionHandler;
        this.initData();
    }

    protected BaseUpload(UploadSource source, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, UpTaskCompletionHandler completionHandler) {
        this(source, null, source.getFileName(), key, token, option, config, recorder, recorderKey, completionHandler);
    }

    protected BaseUpload(byte[] data, String key, String fileName, UpToken token, UploadOptions option, Configuration config, UpTaskCompletionHandler completionHandler) {
        this(null, data, fileName, key, token, option, config, null, null, completionHandler);
    }

    protected void initData() {
        this.currentRegionIndex = 0;
        this.metrics = new UploadTaskMetrics(this.getUpType());
    }

    @Override
    public void run() {
        try {
            this.innerRun();
        }
        catch (Exception e) {
            ResponseInfo responseInfo = ResponseInfo.unexpectedSysCallError(e.getMessage());
            this.completeAction(responseInfo, null);
        }
    }

    private void innerRun() {
        this.metrics.start();
        this.config.zone.query(this.config, this.token, new Zone.QueryHandlerV2(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, ZonesInfo zonesInfo) {
                BaseUpload.this.metrics.setUcQueryMetrics(requestMetrics);
                if (responseInfo != null && responseInfo.isOK() && zonesInfo != null) {
                    if (!BaseUpload.this.setupRegions(zonesInfo)) {
                        responseInfo = ResponseInfo.invalidArgument("setup regions host fail, origin response:" + responseInfo);
                        BaseUpload.this.completeAction(responseInfo, responseInfo.response);
                        return;
                    }
                    int prepareCode = BaseUpload.this.prepareToUpload();
                    if (prepareCode == 0) {
                        BaseUpload.this.startToUpload();
                    } else {
                        ResponseInfo responseInfoP = ResponseInfo.errorInfo(prepareCode, null);
                        BaseUpload.this.completeAction(responseInfoP, null);
                    }
                } else {
                    if (responseInfo == null) {
                        responseInfo = ResponseInfo.sdkInteriorError("can't get regions");
                    }
                    BaseUpload.this.completeAction(responseInfo, responseInfo.response);
                }
            }
        });
    }

    protected boolean reloadUploadInfo() {
        return true;
    }

    protected int prepareToUpload() {
        return 0;
    }

    protected void startToUpload() {
        this.currentRegionRequestMetrics = new UploadRegionRequestMetrics(this.getCurrentRegion());
        this.currentRegionRequestMetrics.start();
    }

    @Deprecated
    protected boolean switchRegionAndUpload() {
        boolean isSwitched;
        if (this.currentRegionRequestMetrics != null) {
            this.currentRegionRequestMetrics.end();
            this.metrics.addMetrics(this.currentRegionRequestMetrics);
            this.currentRegionRequestMetrics = null;
        }
        if (isSwitched = this.switchRegion()) {
            this.startToUpload();
        }
        return isSwitched;
    }

    protected void completeAction(ResponseInfo responseInfo, JSONObject response) {
        if (this.metrics != null) {
            this.metrics.end();
        }
        if (this.currentRegionRequestMetrics != null) {
            this.currentRegionRequestMetrics.end();
        }
        if (this.currentRegionRequestMetrics != null && this.metrics != null) {
            this.metrics.addMetrics(this.currentRegionRequestMetrics);
        }
        if (this.completionHandler != null) {
            this.completionHandler.complete(responseInfo, this.key, this.metrics, response);
        }
    }

    private boolean setupRegions(ZonesInfo zonesInfo) {
        if (zonesInfo == null || ListUtils.isEmpty(zonesInfo.zonesInfo)) {
            return false;
        }
        ArrayList<ZoneInfo> zoneInfos = zonesInfo.zonesInfo;
        ArrayList<UploadDomainRegion> defaultRegions = new ArrayList<UploadDomainRegion>();
        for (ZoneInfo zoneInfo : zoneInfos) {
            UploadDomainRegion region = new UploadDomainRegion(this.config);
            region.setupRegionData(zoneInfo);
            if (!region.isValid()) continue;
            defaultRegions.add(region);
        }
        this.regions = defaultRegions;
        this.metrics.regions = defaultRegions;
        return !defaultRegions.isEmpty();
    }

    protected void insertRegionAtFirst(IUploadRegion region) {
        if (region == null) {
            return;
        }
        boolean hasRegion = false;
        for (IUploadRegion regionP : this.regions) {
            if (!region.isEqual(regionP)) continue;
            hasRegion = true;
            break;
        }
        if (!hasRegion) {
            this.regions.add(0, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean switchRegion() {
        if (this.regions == null) {
            return false;
        }
        boolean ret = false;
        BaseUpload baseUpload = this;
        synchronized (baseUpload) {
            int regionIndex = this.currentRegionIndex + 1;
            if (regionIndex < this.regions.size()) {
                this.currentRegionIndex = regionIndex;
                ret = true;
            }
        }
        return ret;
    }

    protected boolean switchRegionAndUploadIfNeededWithErrorResponse(ResponseInfo errorResponseInfo) {
        if (errorResponseInfo == null || errorResponseInfo.isOK() || !errorResponseInfo.couldRetry() || !this.config.allowBackupHost) {
            return false;
        }
        if (this.currentRegionRequestMetrics != null) {
            this.currentRegionRequestMetrics.end();
            this.metrics.addMetrics(this.currentRegionRequestMetrics);
            this.currentRegionRequestMetrics = null;
        }
        if (!this.reloadUploadInfo()) {
            return false;
        }
        if (!errorResponseInfo.isCtxExpiredError() && !this.switchRegion()) {
            return false;
        }
        this.startToUpload();
        return true;
    }

    protected IUploadRegion getTargetRegion() {
        if (this.regions == null || this.regions.size() == 0) {
            return null;
        }
        return this.regions.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IUploadRegion getCurrentRegion() {
        if (this.regions == null) {
            return null;
        }
        IUploadRegion region = null;
        BaseUpload baseUpload = this;
        synchronized (baseUpload) {
            if (this.currentRegionIndex < this.regions.size()) {
                region = this.regions.get(this.currentRegionIndex);
            }
        }
        return region;
    }

    protected UploadRegionRequestMetrics getCurrentRegionRequestMetrics() {
        return this.currentRegionRequestMetrics;
    }

    protected void addRegionRequestMetricsOfOneFlow(UploadRegionRequestMetrics metrics) {
        if (metrics == null) {
            return;
        }
        if (this.currentRegionRequestMetrics == null) {
            this.currentRegionRequestMetrics = metrics;
        } else {
            this.currentRegionRequestMetrics.addMetrics(metrics);
        }
    }

    abstract String getUpType();

    protected static interface UpTaskCompletionHandler {
        public void complete(ResponseInfo var1, String var2, UploadTaskMetrics var3, JSONObject var4);
    }
}

