/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadMetrics;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.utils.Utils;
import java.util.Date;
import org.json.JSONObject;

public class UploadSingleRequestMetrics
extends UploadMetrics {
    public static final String RequestHijacked = "forsure";
    public static final String RequestMaybeHijacked = "maybe";
    private String hijacked;
    private String syncDnsSource;
    private String syncDnsError;
    private UploadSingleRequestMetrics connectCheckMetrics;
    private Request request;
    private ResponseInfo response;
    private String httpVersion;
    private String clientName = "customized";
    private String clientVersion = "unknown";
    private Date domainLookupStartDate;
    private Date domainLookupEndDate;
    private Date connectStartDate;
    private Date connectEndDate;
    private Date secureConnectionStartDate;
    private Date secureConnectionEndDate;
    private Date requestStartDate;
    private Date requestEndDate;
    private Date responseStartDate;
    private Date responseEndDate;
    private long countOfRequestHeaderBytesSent = 0L;
    private long countOfRequestBodyBytesSent = 0L;
    private long countOfResponseHeaderBytesReceived = 0L;
    private long countOfResponseBodyBytesReceived = 0L;
    private String localAddress;
    private Integer localPort;
    private String remoteAddress;
    private Integer remotePort;
    private long totalBytes = 0L;

    public String getHijacked() {
        return this.hijacked;
    }

    public void setHijacked(String hijacked) {
        this.hijacked = hijacked;
    }

    public String getSyncDnsSource() {
        return this.syncDnsSource;
    }

    public void setSyncDnsSource(String syncDnsSource) {
        this.syncDnsSource = syncDnsSource;
    }

    public String getSyncDnsError() {
        return this.syncDnsError;
    }

    public void setSyncDnsError(String syncDnsError) {
        this.syncDnsError = syncDnsError;
    }

    public UploadSingleRequestMetrics getConnectCheckMetrics() {
        return this.connectCheckMetrics;
    }

    public void setConnectCheckMetrics(UploadSingleRequestMetrics connectCheckMetrics) {
        this.connectCheckMetrics = connectCheckMetrics;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        if (request != null) {
            this.request = request.copyWithoutBody();
            long headerLength = 0L;
            long bodyLength = 0L;
            if (request.allHeaders != null) {
                headerLength = new JSONObject(request.allHeaders).toString().length();
            }
            if (request.httpBody != null) {
                bodyLength = request.httpBody.length;
            }
            this.totalBytes = headerLength + bodyLength;
        }
    }

    public ResponseInfo getResponse() {
        return this.response;
    }

    public void setResponse(ResponseInfo response) {
        this.response = response;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Date getDomainLookupStartDate() {
        return this.domainLookupStartDate;
    }

    public void setDomainLookupStartDate(Date domainLookupStartDate) {
        this.domainLookupStartDate = domainLookupStartDate;
    }

    public Date getDomainLookupEndDate() {
        return this.domainLookupEndDate;
    }

    public void setDomainLookupEndDate(Date domainLookupEndDate) {
        this.domainLookupEndDate = domainLookupEndDate;
    }

    public Date getConnectStartDate() {
        return this.connectStartDate;
    }

    public void setConnectStartDate(Date connectStartDate) {
        this.connectStartDate = connectStartDate;
    }

    public Date getConnectEndDate() {
        return this.connectEndDate;
    }

    public void setConnectEndDate(Date connectEndDate) {
        this.connectEndDate = connectEndDate;
    }

    public Date getSecureConnectionStartDate() {
        return this.secureConnectionStartDate;
    }

    public void setSecureConnectionStartDate(Date secureConnectionStartDate) {
        this.secureConnectionStartDate = secureConnectionStartDate;
    }

    public Date getSecureConnectionEndDate() {
        return this.secureConnectionEndDate;
    }

    public void setSecureConnectionEndDate(Date secureConnectionEndDate) {
        this.secureConnectionEndDate = secureConnectionEndDate;
    }

    public Date getRequestStartDate() {
        return this.requestStartDate;
    }

    public void setRequestStartDate(Date requestStartDate) {
        this.requestStartDate = requestStartDate;
    }

    public Date getRequestEndDate() {
        return this.requestEndDate;
    }

    public void setRequestEndDate(Date requestEndDate) {
        this.requestEndDate = requestEndDate;
    }

    public Date getResponseStartDate() {
        return this.responseStartDate;
    }

    public void setResponseStartDate(Date responseStartDate) {
        this.responseStartDate = responseStartDate;
    }

    public Date getResponseEndDate() {
        return this.responseEndDate;
    }

    public void setResponseEndDate(Date responseEndDate) {
        this.responseEndDate = responseEndDate;
    }

    public long getCountOfRequestHeaderBytesSent() {
        return this.countOfRequestHeaderBytesSent;
    }

    public void setCountOfRequestHeaderBytesSent(long countOfRequestHeaderBytesSent) {
        this.countOfRequestHeaderBytesSent = countOfRequestHeaderBytesSent;
    }

    public long getCountOfRequestBodyBytesSent() {
        return this.countOfRequestBodyBytesSent;
    }

    public void setCountOfRequestBodyBytesSent(long countOfRequestBodyBytesSent) {
        this.countOfRequestBodyBytesSent = countOfRequestBodyBytesSent;
    }

    public long getCountOfResponseHeaderBytesReceived() {
        return this.countOfResponseHeaderBytesReceived;
    }

    public void setCountOfResponseHeaderBytesReceived(long countOfResponseHeaderBytesReceived) {
        this.countOfResponseHeaderBytesReceived = countOfResponseHeaderBytesReceived;
    }

    public long getCountOfResponseBodyBytesReceived() {
        return this.countOfResponseBodyBytesReceived;
    }

    public void setCountOfResponseBodyBytesReceived(long countOfResponseBodyBytesReceived) {
        this.countOfResponseBodyBytesReceived = countOfResponseBodyBytesReceived;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(Integer remotePort) {
        this.remotePort = remotePort;
    }

    public long totalDnsTime() {
        return this.time(this.domainLookupStartDate, this.domainLookupEndDate);
    }

    public long totalConnectTime() {
        return this.time(this.connectStartDate, this.connectEndDate);
    }

    public long totalSecureConnectTime() {
        return this.time(this.secureConnectionStartDate, this.secureConnectionEndDate);
    }

    public long totalRequestTime() {
        return this.time(this.requestStartDate, this.requestEndDate);
    }

    public long totalWaitTime() {
        return this.time(this.requestEndDate, this.responseStartDate);
    }

    public long totalResponseTime() {
        return this.time(this.responseStartDate, this.responseEndDate);
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public Long bytesSend() {
        long bytesSend = this.countOfRequestHeaderBytesSent + this.countOfRequestBodyBytesSent;
        long totalBytes = this.totalBytes();
        if (bytesSend > totalBytes) {
            bytesSend = totalBytes;
        }
        return bytesSend;
    }

    public Long bytesReceived() {
        long bytesReceived = this.countOfResponseHeaderBytesReceived + this.countOfResponseBodyBytesReceived;
        if (bytesReceived < 0L) {
            bytesReceived = 0L;
        }
        return bytesReceived;
    }

    public Long perceptiveSpeed() {
        return Utils.calculateSpeed(this.bytesSend() + this.bytesReceived(), this.totalElapsedTime());
    }

    public boolean isForsureHijacked() {
        return this.hijacked != null && this.hijacked.contains(RequestHijacked);
    }

    public boolean isMaybeHijacked() {
        return this.hijacked != null && this.hijacked.contains(RequestMaybeHijacked);
    }

    private long time(Date startDate, Date endDate) {
        return Utils.dateDuration(startDate, endDate);
    }
}

