/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.http.dns.DnsCacheFile;
import com.qiniu.android.http.dns.DnsCacheInfo;
import com.qiniu.android.http.dns.DnsNetworkAddress;
import com.qiniu.android.http.dns.HttpDns;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.dns.SystemDns;
import com.qiniu.android.http.dns.UdpDns;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.ListUtils;
import com.qiniu.android.utils.Utils;
import com.qiniu.android.utils.Wait;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DnsPrefetcher {
    private Dns customDns;
    private SystemDns systemDns;
    private boolean isPrefetching = false;
    private DnsCacheInfo dnsCacheInfo = null;
    private HashSet<String> prefetchHosts = new HashSet();
    private ConcurrentHashMap<String, List<IDnsNetworkAddress>> addressDictionary = new ConcurrentHashMap();
    private DnsCacheFile diskCache;
    private static final DnsPrefetcher dnsPrefetcher = new DnsPrefetcher();
    public String lastPrefetchErrorMessage;

    private DnsPrefetcher() {
        this.systemDns = new SystemDns(GlobalConfiguration.getInstance().dnsResolveTimeout);
    }

    public static DnsPrefetcher getInstance() {
        return dnsPrefetcher;
    }

    public boolean recoverCache() {
        DnsCacheFile recorder = this.getDiskCache();
        if (recorder == null) {
            return false;
        }
        String localIp = AndroidNetwork.getHostIP();
        if (localIp == null || localIp.length() == 0) {
            return true;
        }
        byte[] data = recorder.get(localIp);
        if (data == null) {
            return true;
        }
        return this.recoverDnsCache(data);
    }

    public void localFetch() {
        this.addPreFetchHosts(this.getLocalPreHost());
    }

    @Deprecated
    public boolean checkAndPrefetchDnsIfNeed(Zone currentZone, UpToken token) {
        return this.checkAndPrefetchDnsIfNeed(null, currentZone, token);
    }

    public boolean checkAndPrefetchDnsIfNeed(Configuration configuration, Zone currentZone, UpToken token) {
        return this.addPreFetchHosts(this.getCurrentZoneHosts(configuration, currentZone, token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPreFetchHosts(String[] hosts) {
        if (hosts == null) {
            return false;
        }
        boolean prefetchHostsContainHosts = true;
        DnsPrefetcher dnsPrefetcher = this;
        synchronized (dnsPrefetcher) {
            int countBeforeAdd = this.prefetchHosts.size();
            this.prefetchHosts.addAll(Arrays.asList(hosts));
            int countAfterAdd = this.prefetchHosts.size();
            if (countAfterAdd > countBeforeAdd) {
                prefetchHostsContainHosts = false;
            }
        }
        if (!prefetchHostsContainHosts) {
            this.checkWhetherCachedDnsValid();
            return true;
        }
        return false;
    }

    public void invalidNetworkAddress(IDnsNetworkAddress address) {
        if (address == null || address.getHostValue() == null) {
            return;
        }
        String host = address.getHostValue();
        List<IDnsNetworkAddress> addressList = this.addressDictionary.get(host);
        if (addressList == null || addressList.size() == 0) {
            return;
        }
        ArrayList<IDnsNetworkAddress> addressListNew = new ArrayList<IDnsNetworkAddress>();
        for (IDnsNetworkAddress addressP : addressList) {
            if (addressP.getIpValue().equals(addressP.getIpValue())) continue;
            addressListNew.add(addressP);
        }
        this.addressDictionary.put(host, addressListNew);
    }

    private void invalidNetworkAddressOfHost(String host) {
        if (host == null || host.length() == 0) {
            return;
        }
        this.addressDictionary.remove(host);
    }

    public List<IDnsNetworkAddress> getInetAddressByHost(String host) {
        DnsNetworkAddress firstAddress;
        if (!this.isDnsOpen()) {
            return null;
        }
        List<IDnsNetworkAddress> addressList = this.addressDictionary.get(host);
        if (addressList != null && addressList.size() > 0 && (firstAddress = (DnsNetworkAddress)addressList.get(0)).isValid()) {
            return addressList;
        }
        return null;
    }

    public String lookupBySafeDns(String hostname) throws UnknownHostException {
        List<IDnsNetworkAddress> addresses;
        List<IDnsNetworkAddress> addresses2;
        if (hostname == null || hostname.length() == 0) {
            return null;
        }
        this.invalidNetworkAddressOfHost(hostname);
        String[] nextFetchHosts = new String[]{hostname};
        int dnsTimeout = GlobalConfiguration.getInstance().dnsResolveTimeout;
        nextFetchHosts = this.preFetchHosts(nextFetchHosts, this.getCustomDns());
        if ((nextFetchHosts == null || nextFetchHosts.length == 0) && (addresses2 = this.getInetAddressByHost(hostname)) != null && addresses2.size() > 0) {
            return addresses2.get(0).getSourceValue();
        }
        HttpDns httpDns = new HttpDns(dnsTimeout);
        if (((nextFetchHosts = this.preFetchHosts(nextFetchHosts, httpDns)) == null || nextFetchHosts.length == 0) && (addresses = this.getInetAddressByHost(hostname)) != null && addresses.size() > 0) {
            return addresses.get(0).getSourceValue();
        }
        return null;
    }

    public void clearDnsCache() throws IOException {
        this.clearMemoryCache();
        this.clearDiskCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkWhetherCachedDnsValid() {
        if (!this.prepareToPreFetch()) {
            return;
        }
        String[] hosts = null;
        DnsPrefetcher dnsPrefetcher = this;
        synchronized (dnsPrefetcher) {
            hosts = this.getCacheHosts();
        }
        this.preFetchHosts(hosts);
        this.endPreFetch();
    }

    private synchronized boolean prepareToPreFetch() {
        if (!this.isDnsOpen()) {
            return false;
        }
        if (this.isPrefetching()) {
            return false;
        }
        String localIp = AndroidNetwork.getHostIP();
        if (localIp == null || this.getDnsCacheInfo() == null || !localIp.equals(this.getDnsCacheInfo().getLocalIp())) {
            this.clearMemoryCache();
        }
        this.setPrefetching(true);
        return true;
    }

    private void endPreFetch() {
        this.setPrefetching(false);
    }

    private void preFetchHosts(String[] fetchHosts) {
        String[] nextFetchHosts = fetchHosts;
        int dnsTimeout = GlobalConfiguration.getInstance().dnsResolveTimeout;
        if ((nextFetchHosts = this.preFetchHosts(nextFetchHosts, this.getCustomDns())) == null || nextFetchHosts.length == 0) {
            return;
        }
        if ((nextFetchHosts = this.preFetchHosts(nextFetchHosts, this.systemDns)) == null || nextFetchHosts.length == 0) {
            return;
        }
        HttpDns httpDns = new HttpDns(dnsTimeout);
        if ((nextFetchHosts = this.preFetchHosts(nextFetchHosts, httpDns)) == null || nextFetchHosts.length == 0) {
            return;
        }
        UdpDns udpDns = new UdpDns(dnsTimeout);
        nextFetchHosts = this.preFetchHosts(nextFetchHosts, udpDns);
        this.recorderDnsCache();
    }

    private String[] preFetchHosts(String[] preHosts, Dns dns) {
        if (preHosts == null || preHosts.length == 0) {
            return null;
        }
        if (dns == null) {
            return preHosts;
        }
        Object exception = null;
        ArrayList<String> failHosts = new ArrayList<String>();
        for (String host : preHosts) {
            boolean isSuccess = false;
            for (int rePreNum = 0; rePreNum < GlobalConfiguration.getInstance().dnsRepreHostNum; ++rePreNum) {
                try {
                    isSuccess = this.preFetchHost(host, dns);
                }
                catch (UnknownHostException e) {
                    this.lastPrefetchErrorMessage = e.toString();
                }
                if (isSuccess) break;
            }
            if (isSuccess) continue;
            failHosts.add(host);
        }
        return failHosts.toArray(new String[0]);
    }

    private boolean preFetchHost(String preHost, Dns dns) throws UnknownHostException {
        DnsNetworkAddress firstAddress;
        if (preHost == null || preHost.length() == 0) {
            return false;
        }
        List<IDnsNetworkAddress> preAddressList = this.addressDictionary.get(preHost);
        if (preAddressList != null && preAddressList.size() > 0 && !(firstAddress = (DnsNetworkAddress)preAddressList.get(0)).needRefresh()) {
            return true;
        }
        boolean isCustomDns = dns == this.getCustomDns();
        UnknownHostException exception = null;
        ArrayList<DnsNetworkAddress> addressList = new ArrayList<DnsNetworkAddress>();
        try {
            List<IDnsNetworkAddress> preIAddressList = dns.lookup(preHost);
            if (preIAddressList != null && preIAddressList.size() > 0) {
                for (IDnsNetworkAddress preIAddress : preIAddressList) {
                    DnsNetworkAddress address = new DnsNetworkAddress(preIAddress.getHostValue(), preIAddress.getIpValue(), preIAddress.getTtlValue() != null ? preIAddress.getTtlValue() : (long)GlobalConfiguration.getInstance().dnsCacheTime, isCustomDns ? "customized" : preIAddress.getSourceValue(), preIAddress.getTimestampValue());
                    addressList.add(address);
                }
            }
        }
        catch (UnknownHostException e) {
            exception = e;
        }
        if (addressList.size() > 0) {
            this.addressDictionary.put(preHost, addressList);
            return true;
        }
        if (exception != null) {
            throw exception;
        }
        return false;
    }

    private boolean recoverDnsCache(byte[] data) {
        DnsCacheInfo dnsCacheInfo = DnsCacheInfo.createDnsCacheInfoByData(data);
        if (dnsCacheInfo == null || dnsCacheInfo.getInfo() == null || dnsCacheInfo.getInfo().size() == 0) {
            return false;
        }
        this.addressDictionary.putAll(dnsCacheInfo.getInfo());
        dnsCacheInfo.setInfo(this.addressDictionary);
        this.setDnsCacheInfo(dnsCacheInfo);
        return false;
    }

    private boolean recorderDnsCache() {
        DnsCacheFile recorder = this.getDiskCache();
        if (recorder == null) {
            return false;
        }
        String currentTime = Utils.currentTimestamp() + "";
        String localIp = AndroidNetwork.getHostIP();
        if (localIp == null) {
            return false;
        }
        DnsCacheInfo dnsCacheInfo = new DnsCacheInfo(currentTime, localIp, this.addressDictionary);
        this.setDnsCacheInfo(dnsCacheInfo);
        byte[] data = dnsCacheInfo.toJsonData();
        if (data == null) {
            return false;
        }
        recorder.set(dnsCacheInfo.cacheKey(), data);
        return true;
    }

    public void clearMemoryCache() {
        this.addressDictionary.clear();
    }

    public void clearDiskCache() throws IOException {
        DnsCacheFile recorder = this.getDiskCache();
        if (recorder == null) {
            return;
        }
        recorder.clearCache();
    }

    private String[] getLocalPreHost() {
        return new String[]{"uplog.qbox.me"};
    }

    private String[] getCurrentZoneHosts(Configuration configuration, Zone currentZone, UpToken token) {
        if (currentZone == null || token == null) {
            return null;
        }
        final Wait wait = new Wait();
        final ZonesInfo[] zonesInfoArray = new ZonesInfo[]{null};
        currentZone.query(configuration, token, new Zone.QueryHandlerV2(){
            final /* synthetic */ DnsPrefetcher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics metrics, ZonesInfo zonesInfo) {
                zonesInfoArray[0] = zonesInfo;
                wait.stopWait();
            }
        });
        wait.startWait();
        if (zonesInfoArray[0] == null) {
            return new String[0];
        }
        ZonesInfo autoZonesInfo = zonesInfoArray[0];
        ArrayList<String> autoHosts = new ArrayList<String>();
        if (!ListUtils.isEmpty(autoZonesInfo.zonesInfo)) {
            for (ZoneInfo zoneInfo : autoZonesInfo.zonesInfo) {
                if (zoneInfo == null || zoneInfo.allHosts == null) continue;
                autoHosts.addAll(zoneInfo.allHosts);
            }
        }
        return autoHosts.toArray(new String[0]);
    }

    private String[] getCacheHosts() {
        return this.prefetchHosts.toArray(new String[0]);
    }

    public boolean isDnsOpen() {
        return GlobalConfiguration.getInstance().isDnsOpen;
    }

    public synchronized boolean isPrefetching() {
        return this.isPrefetching;
    }

    private synchronized void setPrefetching(boolean isPrefetching) {
        this.isPrefetching = isPrefetching;
    }

    private synchronized DnsCacheInfo getDnsCacheInfo() {
        return this.dnsCacheInfo;
    }

    private synchronized DnsCacheFile getDiskCache() {
        if (this.diskCache == null) {
            try {
                this.diskCache = new DnsCacheFile(GlobalConfiguration.getInstance().dnsCacheDir);
            }
            catch (Exception ignored) {
                this.diskCache = null;
            }
        }
        return this.diskCache;
    }

    private synchronized Dns getCustomDns() {
        if (this.customDns == null) {
            this.customDns = GlobalConfiguration.getInstance().dns;
        }
        return this.customDns;
    }

    private synchronized void setDnsCacheInfo(DnsCacheInfo dnsCacheInfo) {
        this.dnsCacheInfo = dnsCacheInfo;
    }
}

