/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.storage.Recorder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DnsCacheFile
implements Recorder {
    public String directory;
    public File f;

    public DnsCacheFile(String directory) throws IOException {
        boolean r;
        if (directory == null) {
            throw new IOException("directory invalid");
        }
        this.directory = directory;
        this.f = new File(directory);
        if (!this.f.exists() && !(r = this.f.mkdirs())) {
            throw new IOException("mkdir failed");
        }
        if (!this.f.isDirectory()) {
            throw new IOException("does not mkdir");
        }
    }

    @Override
    public synchronized void set(String key, byte[] data) {
        File f = new File(this.directory, key);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(f);
            fo.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fo != null) {
            try {
                fo.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized byte[] get(String key) {
        File f = new File(this.directory, key);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fi = null;
        byte[] data = null;
        int read = 0;
        try {
            data = new byte[(int)f.length()];
            fi = new FileInputStream(f);
            read = fi.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fi != null) {
            try {
                fi.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (read == 0) {
            return null;
        }
        return data;
    }

    @Override
    public String getFileName() {
        return "dnsCache";
    }

    @Override
    public synchronized void del(String key) {
        if (key != null) {
            File f = new File(this.directory, key);
            f.delete();
        }
    }

    synchronized void clearCache() throws IOException {
        if (this.f == null) {
            throw new IOException("directory invalid");
        }
        File[] subFiles = this.f.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            for (File f : subFiles) {
                f.delete();
            }
        }
    }
}

