/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.bigdata.pipeline;

import com.qiniu.android.bigdata.Configuration;
import com.qiniu.android.bigdata.client.Client;
import com.qiniu.android.bigdata.client.CompletionHandler;
import com.qiniu.android.bigdata.pipeline.Points;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.utils.StringMap;
import com.qiniu.android.utils.StringUtils;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class Pipeline {
    private static final String HTTPHeaderAuthorization = "Authorization";
    private static final String TEXT_PLAIN = "text/plain";
    private final Configuration config;
    private final Client client;

    public Pipeline(Configuration config) {
        this.config = Configuration.copy(config);
        this.client = new Client(this.config.proxy, this.config.connectTimeout, this.config.responseTimeout, null, null);
    }

    public <V> void pump(String repo, Map<String, V> data, String token, PumpCompleteHandler handler) {
        StringBuilder b = new StringBuilder();
        Points.formatPoint(data, b);
        this.send(repo, b, token, handler);
    }

    public void pump(String repo, Object data, String token, PumpCompleteHandler handler) {
        StringBuilder b = new StringBuilder();
        Points.formatPoint(data, b);
        this.send(repo, b, token, handler);
    }

    public <V> void pumpMulti(String repo, Map<String, V>[] data, String token, PumpCompleteHandler handler) {
        StringBuilder b = Points.formatPoints(data);
        this.send(repo, b, token, handler);
    }

    public void pumpMultiObjects(String repo, Object[] data, String token, PumpCompleteHandler handler) {
        StringBuilder b = Points.formatPoints(data);
        this.send(repo, b, token, handler);
    }

    public <V> void pumpMultiObjects(String repo, List<V> data, String token, PumpCompleteHandler handler) {
        StringBuilder b = Points.formatPointsObjects(data);
        this.send(repo, b, token, handler);
    }

    public <V> void pumpMulti(String repo, List<Map<String, V>> data, String token, PumpCompleteHandler handler) {
        StringBuilder b = Points.formatPoints(data);
        this.send(repo, b, token, handler);
    }

    private void send(String repo, StringBuilder builder, String token, final PumpCompleteHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("no CompletionHandler");
        }
        if (StringUtils.isBlank(token)) {
            throw new IllegalArgumentException("no token");
        }
        if (StringUtils.isBlank(repo)) {
            throw new IllegalArgumentException("no repo");
        }
        byte[] data = builder.toString().getBytes();
        StringMap headers = new StringMap();
        headers.put(HTTPHeaderAuthorization, token);
        headers.put("Content-Type", TEXT_PLAIN);
        this.client.asyncPost(this.url(repo), data, headers, null, data.length, null, new CompletionHandler(){
            final /* synthetic */ Pipeline this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                handler.complete(info);
            }
        }, null);
    }

    private String url(String repo) {
        return this.config.pipelineHost + "/v2/repos/" + repo + "/data";
    }

    public static interface PumpCompleteHandler {
        public void complete(ResponseInfo var1);
    }
}

