/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.traceroute;

import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.qcloud.network.sonar.SonarCallback;
import com.tencent.qcloud.network.sonar.command.CommandStatus;
import com.tencent.qcloud.network.sonar.command.NetCommandTask;
import com.tencent.qcloud.network.sonar.traceroute.SingleNodeResult;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteNodeResult;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;

final class TracerouteTask
extends NetCommandTask<TracerouteNodeResult> {
    private final String targetIp;
    private final int count;
    private final int hop;
    private SonarCallback.Step<TracerouteNodeResult> stepCallback;

    TracerouteTask(String targetIp, int hop, int count, SonarCallback.Step<TracerouteNodeResult> stepCallback) {
        this.targetIp = targetIp;
        this.hop = hop;
        this.count = count;
        this.stepCallback = stepCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TracerouteNodeResult run() {
        this.isRunning = true;
        this.command = String.format("ping -c 1 -W 1 -t %d %s", this.hop, this.targetIp);
        int currentCount = 0;
        ArrayList<SingleNodeResult> singleNodeList = new ArrayList<SingleNodeResult>();
        while (this.isRunning && currentCount < this.count) {
            try {
                long startTime = SystemClock.elapsedRealtime();
                String cmdRes = this.execCommand(this.command);
                int delay = (int)(SystemClock.elapsedRealtime() - startTime);
                float tmpElapsed = COMMAND_ELAPSED_TIME;
                while ((double)((float)delay - tmpElapsed) < (double)delay * 0.1 && tmpElapsed > COMMAND_ELAPSED_TIME * 0.1f) {
                    tmpElapsed = (float)((double)tmpElapsed * 0.8);
                }
                SonarLog.d(this.TAG, String.format("[traceroute delay]:%d [COMMAND_ELAPSED_TIME]:%f [tmpElapsed]%f", delay, Float.valueOf(COMMAND_ELAPSED_TIME), Float.valueOf(tmpElapsed)));
                delay = (int)((float)delay - tmpElapsed);
                SingleNodeResult nodeResult = this.parseSingleNodeInfoInput(cmdRes);
                if (!nodeResult.isFinalRoute() && nodeResult.getStatus() == CommandStatus.CMD_STATUS_SUCCESSFUL) {
                    nodeResult.setDelay(delay);
                }
                singleNodeList.add(nodeResult);
            }
            catch (IOException | InterruptedException e) {
                SonarLog.d(this.TAG, String.format("traceroute[%d]: %s occur error: %s", currentCount, this.command, e.getMessage()));
            }
            finally {
                ++currentCount;
            }
        }
        this.resultData = new TracerouteNodeResult(this.targetIp, this.hop, singleNodeList);
        if (this.stepCallback != null) {
            this.stepCallback.step((TracerouteNodeResult)this.resultData);
        }
        return this.isRunning ? (TracerouteNodeResult)this.resultData : null;
    }

    protected SingleNodeResult parseSingleNodeInfoInput(String input) {
        SonarLog.d(this.TAG, "[hop]:" + this.hop + " [org data]:" + input);
        SingleNodeResult nodeResult = new SingleNodeResult(this.targetIp, this.hop);
        if (TextUtils.isEmpty((CharSequence)input)) {
            nodeResult.setStatus(CommandStatus.CMD_STATUS_NETWORK_ERROR);
            nodeResult.setDelay(0.0f);
            return nodeResult;
        }
        Matcher matcherRouteNode = this.matcherRouteNode(input);
        if (matcherRouteNode.find()) {
            nodeResult.setRouteIp(this.getIpFromMatcher(matcherRouteNode));
            nodeResult.setStatus(CommandStatus.CMD_STATUS_SUCCESSFUL);
        } else {
            Matcher matcherTargetId = this.matcherIp(input);
            if (matcherTargetId.find()) {
                nodeResult.setRouteIp(matcherTargetId.group());
                nodeResult.setStatus(CommandStatus.CMD_STATUS_SUCCESSFUL);
                String time = this.getPingDelayFromMatcher(this.matcherTime(input));
                nodeResult.setDelay(Float.parseFloat(time));
            } else {
                nodeResult.setStatus(CommandStatus.CMD_STATUS_FAILED);
                nodeResult.setDelay(0.0f);
            }
        }
        return nodeResult;
    }

    @Override
    protected void parseInputInfo(String input) {
    }

    @Override
    protected void parseErrorInfo(String error) {
        if (!TextUtils.isEmpty((CharSequence)error)) {
            SonarLog.d(this.TAG, "[hop]:" + this.hop + " [error data]:" + error);
        }
    }

    @Override
    protected void stop() {
        this.isRunning = false;
    }
}

