/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.traceroute;

import android.text.TextUtils;
import com.tencent.qcloud.network.sonar.command.CommandStatus;
import com.tencent.qcloud.network.sonar.command.NetCommandResult;
import com.tencent.qcloud.network.sonar.traceroute.SingleNodeResult;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TracerouteNodeResult
extends NetCommandResult {
    private int hop;
    private String routeIp;
    private boolean isFinalRoute;
    private List<SingleNodeResult> singleNodeList;

    protected TracerouteNodeResult(String targetIp, int hop, List<SingleNodeResult> singleNodeList) {
        super(targetIp);
        this.hop = hop;
        this.isFinalRoute = false;
        this.routeIp = "*";
        this.setSingleNodeList(singleNodeList);
    }

    public int getHop() {
        return this.hop;
    }

    public String getRouteIp() {
        return this.routeIp;
    }

    public boolean isFinalRoute() {
        return this.isFinalRoute;
    }

    TracerouteNodeResult setHop(int hop) {
        this.hop = hop;
        return this;
    }

    TracerouteNodeResult setRouteIp(String routeIp) {
        this.routeIp = routeIp;
        this.isFinalRoute = TextUtils.equals((CharSequence)this.targetIp, (CharSequence)routeIp);
        return this;
    }

    TracerouteNodeResult setFinalRoute(boolean isFinalRoute) {
        this.isFinalRoute = isFinalRoute;
        return this;
    }

    public List<SingleNodeResult> getSingleNodeList() {
        return this.singleNodeList;
    }

    void setSingleNodeList(List<SingleNodeResult> singleNodeList) {
        this.singleNodeList = singleNodeList;
        if (this.singleNodeList == null) {
            return;
        }
        for (SingleNodeResult node : this.singleNodeList) {
            if (TextUtils.equals((CharSequence)"*", (CharSequence)node.getRouteIp())) continue;
            this.setRouteIp(node.getRouteIp());
            break;
        }
    }

    public int averageDelay() {
        if (this.singleNodeList == null || this.singleNodeList.isEmpty()) {
            return 0;
        }
        int count = 0;
        float total = 0.0f;
        for (SingleNodeResult node : this.singleNodeList) {
            if (node == null || node.delay <= 0.0f) continue;
            ++count;
            total += node.delay;
        }
        return Math.round(total / (float)count);
    }

    public float lossRate() {
        if (this.singleNodeList == null || this.singleNodeList.isEmpty()) {
            return 1.0f;
        }
        int loss = 0;
        float total = this.singleNodeList.size();
        for (SingleNodeResult node : this.singleNodeList) {
            if (node != null && node.getStatus() == CommandStatus.CMD_STATUS_SUCCESSFUL && node.delay != 0.0f) continue;
            ++loss;
        }
        return (float)loss / total;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject json;
        block2: {
            json = super.toJson();
            try {
                json.put("hop", this.hop);
                json.put("route_ip", (Object)this.routeIp);
                json.put("avg_delay", this.averageDelay());
                json.put("loss", (Object)String.format("%.2f", Float.valueOf(this.lossRate())));
                json.put("is_final_route", this.isFinalRoute);
            }
            catch (JSONException e) {
                if (!SonarLog.openLog) break block2;
                e.printStackTrace();
            }
        }
        return json;
    }
}

