/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.ping;

import com.tencent.qcloud.network.sonar.utils.SonarLog;
import org.json.JSONException;
import org.json.JSONObject;

public class PingResult {
    public final String result;
    public final String host;
    public final String ip;
    public final int size;
    public final int interval;
    private final String lastLinePrefix = "rtt min/avg/max/mdev = ";
    private final String packetWords = " packets transmitted";
    private final String receivedWords = " received";
    public int sent;
    public int dropped;
    public float max;
    public float min;
    public float avg;
    public float stddev;
    public int count;
    public long timeConsuming;

    PingResult(String result, String host, String ip, int size, int interval) {
        this.result = result;
        this.ip = ip;
        this.size = size;
        this.interval = interval;
        this.host = host;
        this.parseResult();
    }

    static String trimNoneDigital(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char[] v = s.toCharArray();
        char[] v2 = new char[v.length];
        int j = 0;
        for (char aV : v) {
            if ((aV < '0' || aV > '9') && aV != '.') continue;
            v2[j++] = aV;
        }
        return new String(v2, 0, j);
    }

    private void parseRttLine(String s) {
        String s2 = s.substring("rtt min/avg/max/mdev = ".length(), s.length() - 3);
        String[] l = s2.split("/");
        if (l.length != 4) {
            return;
        }
        this.min = Float.parseFloat(PingResult.trimNoneDigital(l[0]));
        this.avg = Float.parseFloat(PingResult.trimNoneDigital(l[1]));
        this.max = Float.parseFloat(PingResult.trimNoneDigital(l[2]));
        this.stddev = Float.parseFloat(PingResult.trimNoneDigital(l[3]));
    }

    private void parsePacketLine(String s) {
        String[] l = s.split(",");
        if (l.length != 4) {
            return;
        }
        if (l[0].length() > " packets transmitted".length()) {
            String s2 = l[0].substring(0, l[0].length() - " packets transmitted".length());
            this.count = Integer.parseInt(s2);
        }
        if (l[1].length() > " received".length()) {
            String s3 = l[1].substring(0, l[1].length() - " received".length());
            this.sent = Integer.parseInt(s3.trim());
        }
        this.dropped = this.count - this.sent;
    }

    private void parseResult() {
        block4: {
            String[] rs = this.result.split("\n");
            try {
                for (String s : rs) {
                    if (s.contains(" packets transmitted")) {
                        this.parsePacketLine(s);
                        continue;
                    }
                    if (!s.contains("rtt min/avg/max/mdev = ")) continue;
                    this.parseRttLine(s);
                }
            }
            catch (Exception e) {
                if (!SonarLog.openLog) break block4;
                e.printStackTrace();
            }
        }
    }

    public int getResponseNum() {
        return this.sent;
    }

    public float getLoss() {
        if (0 == this.count) {
            return 1.0f;
        }
        return (float)this.dropped / (float)this.count;
    }

    public String encode() {
        JSONObject o = new JSONObject();
        try {
            o.put("method", (Object)"ping");
            o.put("ip", (Object)this.ip);
            o.put("host", (Object)this.host);
            o.put("max", (Object)String.format("%.2f", Float.valueOf(this.max)));
            o.put("min", (Object)String.format("%.2f", Float.valueOf(this.min)));
            o.put("avg", (Object)String.format("%.2f", Float.valueOf(this.avg)));
            o.put("stddev", (Object)String.format("%.2f", Float.valueOf(this.stddev)));
            if (0 == this.count) {
                o.put("loss", (Object)"1");
            } else {
                o.put("loss", (Object)String.format("%.2f", Float.valueOf(Float.valueOf(this.dropped).floatValue() / Float.valueOf(this.count).floatValue())));
            }
            o.put("count", this.count);
            o.put("size", this.size);
            o.put("responseNum", this.sent);
            o.put("interval", this.interval);
            o.put("timestamp", System.currentTimeMillis() / 1000L);
            o.put("timeConsuming", this.timeConsuming);
            return o.toString();
        }
        catch (JSONException err) {
            if (SonarLog.openLog) {
                err.printStackTrace();
            }
            return null;
        }
    }

    public String toString() {
        return this.encode();
    }
}

