/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.dns;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.os.Build;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.minidns.dnsserverlookup.AbstractDnsServerLookupMechanism;
import org.minidns.util.PlatformDetection;

public class AndroidDnsServerLookup
extends AbstractDnsServerLookupMechanism {
    public static final int PRIORITY = 1000;
    private final Context context;

    public AndroidDnsServerLookup(Context context) {
        super(AndroidDnsServerLookup.class.getSimpleName(), 1000);
        this.context = context.getApplicationContext();
    }

    public boolean isAvailable() {
        return PlatformDetection.isAndroid();
    }

    public List<String> getDnsServerAddresses() {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
                Network network = cm.getActiveNetwork();
                LinkProperties linkProperties = cm.getLinkProperties(network);
                ArrayList<String> servers = new ArrayList<String>();
                for (InetAddress inetAddress : linkProperties.getDnsServers()) {
                    servers.add(inetAddress.getHostAddress());
                }
                return servers;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception in findDNSByReflection", e);
            }
        }
        return null;
    }
}

