/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger.channel;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.tencent.qcloud.core.logger.LogEntity;
import com.tencent.qcloud.core.logger.channel.BaseLogChannel;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FileChannel
extends BaseLogChannel {
    private static final String LOG_DIR = "QCloudLogs";
    private static final int MAX_FILE_SIZE = 0x300000;
    private static final long LOG_FLUSH_DURATION = 10000L;
    private static final long BUFFER_SIZE = 32768L;
    private static final int MAX_FILE_COUNT = 30;
    private final File logRootDir;
    private File latestLogFile;
    private static final int MSG_FLUSH_ALL = 0;
    private static final int MSG_FLUSH_CONTENT = 1;
    private final Handler handler;
    private final List<LogEntity> bufferRecord = Collections.synchronizedList(new ArrayList());
    private volatile long mBufferSize = 0L;
    private static final byte[] object = new byte[0];
    private byte[] encryptionKey = null;
    private byte[] ivParameter = null;
    private static FileChannel instance;
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileChannel getInstance(Context context) {
        Class<FileChannel> clazz = FileChannel.class;
        synchronized (FileChannel.class) {
            if (instance == null) {
                instance = new FileChannel(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private FileChannel(Context context) {
        this.logRootDir = new File(context.getExternalCacheDir() + File.separator + LOG_DIR);
        HandlerThread handlerThread = new HandlerThread("log_handlerThread", 1);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        FileChannel.this.flush();
                        this.sendEmptyMessageDelayed(0, 10000L);
                        break;
                    }
                    case 1: {
                        FileChannel.this.input();
                    }
                }
            }
        };
        Message message = this.handler.obtainMessage();
        message.what = 0;
        this.handler.sendMessage(message);
    }

    @Override
    public synchronized void log(LogEntity entity) {
        if (!this.isLoggable(entity)) {
            return;
        }
        this.bufferRecord.add(entity);
        this.mBufferSize += entity.getLength();
        this.handler.removeMessages(1);
        this.handler.sendEmptyMessageDelayed(1, 500L);
    }

    public boolean isLoggable(LogEntity entity) {
        if (!this.isEnabled() || entity == null) {
            return false;
        }
        return entity.getLevel().isLoggable(this.getMinLevel());
    }

    private String formatDateString(long times) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss", Locale.getDefault());
        return simpleDateFormat.format(times);
    }

    private boolean isSameDay(String timesString, long dateTime) {
        SimpleDateFormat fmt1 = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss", Locale.getDefault());
        SimpleDateFormat fmt2 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            String string1 = fmt2.format(fmt1.parse(timesString));
            String string2 = fmt2.format(dateTime);
            return string1.equals(string2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public File[] getLogFilesDesc(int limit) {
        if (this.logRootDir.listFiles() != null && this.logRootDir.listFiles().length > 0) {
            File[] logFiles = this.logRootDir.listFiles();
            Arrays.sort(logFiles, new Comparator<File>(){

                @Override
                public int compare(File lhs, File rhs) {
                    return Long.valueOf(rhs.lastModified()).compareTo(lhs.lastModified());
                }
            });
            File[] required = new File[Math.min(limit, logFiles.length)];
            System.arraycopy(logFiles, 0, required, 0, required.length);
            return required;
        }
        return null;
    }

    public String getLogRootDir() {
        return this.logRootDir.getAbsolutePath();
    }

    private File getLogFile(long times) {
        String fileName;
        String fileLogDate;
        File[] logFiles = this.logRootDir.listFiles();
        if (this.latestLogFile == null) {
            if (!this.logRootDir.exists() && !this.logRootDir.mkdirs()) {
                return null;
            }
            if (logFiles != null && logFiles.length > 0) {
                Arrays.sort(logFiles, new Comparator<File>(){

                    @Override
                    public int compare(File lhs, File rhs) {
                        return Long.valueOf(rhs.lastModified()).compareTo(lhs.lastModified());
                    }
                });
                for (File file : logFiles) {
                    boolean isEncryptedFile = file.getName().contains("_encrypt");
                    if ((this.encryptionKey == null || !isEncryptedFile) && (this.encryptionKey != null || isEncryptedFile)) continue;
                    this.latestLogFile = file;
                    break;
                }
            }
        }
        if (this.latestLogFile != null && this.latestLogFile.length() < 0x300000L && this.isSameDay(fileLogDate = (fileName = this.latestLogFile.getName()).replace("_encrypt.log", "").replace(".log", ""), times)) {
            boolean isEncryptedFile = fileName.contains("_encrypt");
            if (this.encryptionKey != null && isEncryptedFile || this.encryptionKey == null && !isEncryptedFile) {
                return this.latestLogFile;
            }
        }
        fileName = this.formatDateString(times) + (this.encryptionKey != null ? "_encrypt" : "") + ".log";
        this.latestLogFile = new File(this.logRootDir + File.separator + fileName);
        this.cleanFilesIfNecessary(logFiles);
        return this.latestLogFile;
    }

    private void cleanFilesIfNecessary(File[] logFiles) {
        if (logFiles != null && logFiles.length >= 30) {
            logFiles[logFiles.length - 1].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(List<LogEntity> listInfo) {
        byte[] byArray = object;
        synchronized (object) {
            if (listInfo == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FilterOutputStream dos = null;
            try {
                File file = this.getLogFile(System.currentTimeMillis());
                if (file != null) {
                    dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, true), 8192));
                    for (int i = 0; i < listInfo.size(); ++i) {
                        byte[] logBytes = listInfo.get(i).toString().getBytes("UTF-8");
                        if (this.encryptionKey != null) {
                            try {
                                this.appendEncryptedLog((DataOutputStream)dos, logBytes);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        dos.write(logBytes);
                    }
                    ((DataOutputStream)dos).flush();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private synchronized void flush() {
        if (this.mBufferSize <= 0L) {
            return;
        }
        this.write(this.bufferRecord);
        this.bufferRecord.clear();
        this.mBufferSize = 0L;
    }

    private synchronized void input() {
        if (this.mBufferSize > 32768L) {
            this.flush();
        }
    }

    public void setEncryptionKey(byte[] key, byte[] iv) {
        this.encryptionKey = key != null ? (byte[])key.clone() : null;
        this.ivParameter = iv != null ? (byte[])iv.clone() : null;
    }

    public void appendEncryptedLog(DataOutputStream dos, byte[] logBytes) throws Exception {
        IvParameterSpec ivSpec = new IvParameterSpec(this.ivParameter);
        SecretKeySpec keySpec = new SecretKeySpec(this.encryptionKey, "AES");
        byte[] encrypted = this.encryptSingle(logBytes, keySpec, ivSpec);
        dos.writeInt(encrypted.length);
        dos.write(encrypted);
    }

    private byte[] encryptSingle(byte[] plaintext, SecretKeySpec keySpec, IvParameterSpec ivSpec) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)keySpec, ivSpec);
        return cipher.doFinal(plaintext);
    }
}

