/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.qcloud.core.logger.LogCategory;
import com.tencent.qcloud.core.logger.LogEntity;
import com.tencent.qcloud.core.logger.LogLevel;
import com.tencent.qcloud.core.logger.channel.BaseLogChannel;
import com.tencent.qcloud.core.logger.channel.ClsChannel;
import com.tencent.qcloud.core.logger.channel.CosLogListener;
import com.tencent.qcloud.core.logger.channel.FileChannel;
import com.tencent.qcloud.core.logger.channel.ListenerChannel;
import com.tencent.qcloud.core.logger.channel.LogcatChannel;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.track.cls.ClsLifecycleCredentialProvider;
import com.tencent.qcloud.track.service.ClsTrackService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class COSLogger {
    private static COSLogger instance;
    private final List<BaseLogChannel> channels = new ArrayList<BaseLogChannel>();
    private final LogcatChannel logcatChannel;
    private final FileChannel fileChannel;
    private LogLevel minLevel;
    private final Context context;
    private final Map<String, String> sensitivePatterns = new HashMap<String, String>();
    private Map<String, String> extras = new HashMap<String, String>();
    private String deviceID;
    private String deviceModel;
    private String appVersion;

    private COSLogger(boolean enableLogcat, boolean enableFile) {
        this.context = ContextHolder.getAppContext();
        this.minLevel = LogLevel.VERBOSE;
        this.logcatChannel = new LogcatChannel();
        this.logcatChannel.setEnabled(enableLogcat);
        this.channels.add(this.logcatChannel);
        this.fileChannel = FileChannel.getInstance(this.context);
        this.fileChannel.setEnabled(enableFile);
        this.channels.add(this.fileChannel);
        this.sensitivePatterns.put("(q-ak=)[^&\\\\s]+", "$1***");
        this.sensitivePatterns.put("(x-cos-security-token:\\s*)[^\\s]+", "$1***");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static COSLogger getInstance() {
        Class<COSLogger> clazz = COSLogger.class;
        synchronized (COSLogger.class) {
            if (instance == null) {
                instance = new COSLogger(false, false);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void log(LogLevel level, LogCategory category, String tag, String message, Throwable throwable) {
        try {
            if (TextUtils.isEmpty((CharSequence)message)) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)tag)) {
                tag = "COSLogger";
            }
            String processedMessage = this.desensitize(message);
            this.extras.put("qcloud_platform", "Android");
            if (!TextUtils.isEmpty((CharSequence)this.deviceID)) {
                this.extras.put("deviceID", this.deviceID);
            }
            if (!TextUtils.isEmpty((CharSequence)this.deviceModel)) {
                this.extras.put("deviceModel", this.deviceModel);
            }
            if (!TextUtils.isEmpty((CharSequence)this.appVersion)) {
                this.extras.put("appVersion", this.appVersion);
            }
            LogEntity entity = new LogEntity(level, category, tag, processedMessage, this.extras, throwable);
            for (BaseLogChannel channel : this.channels) {
                LogLevel channelLevel;
                LogLevel effectiveLevel;
                if (!channel.isEnabled() || !level.isLoggable(effectiveLevel = (channelLevel = channel.getMinLevel()) != null ? channelLevel : this.minLevel)) continue;
                channel.log(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dProcess(String tag, String message) {
        COSLogger.getInstance().log(LogLevel.DEBUG, LogCategory.PROCESS, tag, message, null);
    }

    public static void dProcess(String tag, String format, Object ... args) {
        COSLogger.getInstance().log(LogLevel.DEBUG, LogCategory.PROCESS, tag, COSLogger.formatMessage(format, args), null);
    }

    public static void dProcess(String tag, String message, Throwable throwable) {
        COSLogger.getInstance().log(LogLevel.DEBUG, LogCategory.PROCESS, tag, message, throwable);
    }

    public static void iProcess(String tag, String message) {
        COSLogger.getInstance().log(LogLevel.INFO, LogCategory.PROCESS, tag, message, null);
    }

    public static void iProcess(String tag, String format, Object ... args) {
        COSLogger.getInstance().log(LogLevel.INFO, LogCategory.PROCESS, tag, COSLogger.formatMessage(format, args), null);
    }

    public static void iProcess(String tag, String message, Throwable throwable) {
        COSLogger.getInstance().log(LogLevel.INFO, LogCategory.PROCESS, tag, message, throwable);
    }

    public static void iNetwork(String tag, String message) {
        COSLogger.getInstance().log(LogLevel.INFO, LogCategory.NETWORK, tag, message, null);
    }

    public static void iNetwork(String tag, String format, Object ... args) {
        COSLogger.getInstance().log(LogLevel.INFO, LogCategory.NETWORK, tag, COSLogger.formatMessage(format, args), null);
    }

    public static void iProbe(String tag, String message) {
        COSLogger.getInstance().log(LogLevel.INFO, LogCategory.PROBE, tag, message, null);
    }

    public static void wProcess(String tag, String message) {
        COSLogger.getInstance().log(LogLevel.WARN, LogCategory.PROCESS, tag, message, null);
    }

    public static void wProcess(String tag, String format, Object ... args) {
        COSLogger.getInstance().log(LogLevel.WARN, LogCategory.PROCESS, tag, COSLogger.formatMessage(format, args), null);
    }

    public static void wNetwork(String tag, String message) {
        COSLogger.getInstance().log(LogLevel.WARN, LogCategory.NETWORK, tag, message, null);
    }

    public static void wNetwork(String tag, String format, Object ... args) {
        COSLogger.getInstance().log(LogLevel.WARN, LogCategory.NETWORK, tag, COSLogger.formatMessage(format, args), null);
    }

    private static String formatMessage(String format, Object ... args) {
        String message;
        try {
            message = args != null && args.length > 0 ? String.format(format, args) : format;
        }
        catch (Exception e) {
            message = format + ": !!!! Log format exception: ";
        }
        return message;
    }

    public static void enableLogcat(boolean enable) {
        COSLogger.getInstance().logcatChannel.setEnabled(enable);
    }

    public static void enableLogFile(boolean enable) {
        COSLogger.getInstance().fileChannel.setEnabled(enable);
    }

    public static void addLogListener(CosLogListener listener) {
        COSLogger.getInstance().channels.add(new ListenerChannel(listener));
    }

    public static void removeLogListener(CosLogListener listener) {
        for (BaseLogChannel channel : COSLogger.getInstance().channels) {
            ListenerChannel listenerChannel;
            if (!(channel instanceof ListenerChannel) || (listenerChannel = (ListenerChannel)channel).getListener() != listener) continue;
            COSLogger.getInstance().channels.remove(channel);
            break;
        }
    }

    public static void setMinLevel(LogLevel minLevel) {
        COSLogger.getInstance().minLevel = minLevel;
    }

    public static void setLogcatMinLevel(LogLevel minLevel) {
        COSLogger.getInstance().logcatChannel.setMinLevel(minLevel);
    }

    public static void setFileMinLevel(LogLevel minLevel) {
        COSLogger.getInstance().fileChannel.setMinLevel(minLevel);
    }

    public static void setClsMinLevel(LogLevel minLevel) {
        for (BaseLogChannel channel : COSLogger.getInstance().channels) {
            if (!(channel instanceof ClsChannel)) continue;
            ClsChannel clsChannel = (ClsChannel)channel;
            clsChannel.setMinLevel(minLevel);
        }
    }

    public static void setExtras(Map<String, String> extras) {
        COSLogger.getInstance().extras = extras;
    }

    public static void setDeviceID(String deviceID) {
        COSLogger.getInstance().deviceID = deviceID;
    }

    public static void setDeviceModel(String deviceModel) {
        COSLogger.getInstance().deviceModel = deviceModel;
    }

    public static void setAppVersion(String appVersion) {
        COSLogger.getInstance().appVersion = appVersion;
    }

    public static void setLogFileEncryptionKey(byte[] key, byte[] iv) {
        COSLogger.getInstance().fileChannel.setEncryptionKey(key, iv);
    }

    public static File[] getLogFiles(int limit) {
        return COSLogger.getInstance().fileChannel.getLogFilesDesc(limit);
    }

    public static String getLogRootDir() {
        return COSLogger.getInstance().fileChannel.getLogRootDir();
    }

    public static void setCLsChannel(String topicId, String endpoint) {
        if (!ClsTrackService.isInclude()) {
            throw new IllegalStateException("Please quote the cls library first: com.tencentcloudapi.cls:tencentcloud-cls-sdk-android:x.x.x");
        }
        ClsTrackService clsTrackService = new ClsTrackService();
        clsTrackService.init(COSLogger.getInstance().context, topicId, endpoint);
        clsTrackService.setSecurityCredential("secretId", "secretKey");
        COSLogger.getInstance().channels.add(new ClsChannel(clsTrackService));
    }

    public static void setCLsChannel(String topicId, String endpoint, String secretId, String secretKey) {
        if (!ClsTrackService.isInclude()) {
            throw new IllegalStateException("Please quote the cls library first: com.tencentcloudapi.cls:tencentcloud-cls-sdk-android:x.x.x");
        }
        ClsTrackService clsTrackService = new ClsTrackService();
        clsTrackService.init(COSLogger.getInstance().context, topicId, endpoint);
        clsTrackService.setSecurityCredential(secretId, secretKey);
        COSLogger.getInstance().channels.add(new ClsChannel(clsTrackService));
    }

    public static void setCLsChannel(String topicId, String endpoint, ClsLifecycleCredentialProvider lifecycleCredentialProvider) {
        if (!ClsTrackService.isInclude()) {
            throw new IllegalStateException("Please quote the cls library first: com.tencentcloudapi.cls:tencentcloud-cls-sdk-android:x.x.x");
        }
        ClsTrackService clsTrackService = new ClsTrackService();
        clsTrackService.init(COSLogger.getInstance().context, topicId, endpoint);
        clsTrackService.setCredentialProvider(lifecycleCredentialProvider);
        COSLogger.getInstance().channels.add(new ClsChannel(clsTrackService));
    }

    public static void addSensitiveRule(String regex, String replacement) {
        if (TextUtils.isEmpty((CharSequence)regex) || TextUtils.isEmpty((CharSequence)replacement)) {
            return;
        }
        COSLogger.getInstance().sensitivePatterns.put(regex, replacement);
    }

    public static void removeSensitiveRule(String regex) {
        COSLogger.getInstance().sensitivePatterns.remove(regex);
    }

    private String desensitize(String input) {
        if (TextUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        String result = input;
        for (String regex : this.sensitivePatterns.keySet()) {
            result = result.replaceAll(regex, this.sensitivePatterns.get(regex));
        }
        return result;
    }
}

