/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http.interceptor;

import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.interceptor.CircuitBreakerDeniedException;
import com.tencent.qcloud.core.logger.COSLogger;
import com.tencent.qcloud.core.task.TaskManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CircuitBreakerInterceptor
implements Interceptor {
    private AtomicInteger failedCount = new AtomicInteger(0);
    private AtomicInteger successCount = new AtomicInteger(0);
    private State state = State.CLOSED;
    private long entryOpenStateTimestamp;
    private long recentErrorTimestamp;
    private FootprintWriter footprintWriter = new FootprintWriter();
    private static final int THRESHOLD_STATE_SWITCH_FOR_CONTINUOUS_FAIL = 5;
    private static final int THRESHOLD_STATE_SWITCH_FOR_CONTINUOUS_SUCCESS = 2;
    private static final long TIMEOUT_FOR_OPEN_STATE = 10000L;
    private static final long TIMEOUT_FOR_RESET_ALL = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
        if (task == null || task.isCanceled()) {
            throw new IOException("CANCELED");
        }
        Class<CircuitBreakerInterceptor> clazz = CircuitBreakerInterceptor.class;
        synchronized (CircuitBreakerInterceptor.class) {
            boolean isFreshTask;
            long openDuration;
            if (this.state == State.OPEN && (openDuration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.entryOpenStateTimestamp)) > 10000L) {
                this.state = State.HALF_OPENED;
            }
            if (this.recentErrorTimestamp > 0L && TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.recentErrorTimestamp) > 60000L) {
                this.state = State.CLOSED;
                this.successCount.set(0);
                this.failedCount.set(0);
                this.recentErrorTimestamp = 0L;
            }
            if (isFreshTask = this.footprintWriter.noRecords(task)) {
                this.footprintWriter.remember(task);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (this.state == State.OPEN && (task.isDownloadTask() || task.isUploadTask()) && !isFreshTask) {
                COSLogger.iNetwork("QCloudHttp", "CircuitBreaker deny %s", request);
                throw new CircuitBreakerDeniedException("too many continuous errors.");
            }
            try {
                Response response = chain.proceed(request);
                Class<CircuitBreakerInterceptor> clazz2 = CircuitBreakerInterceptor.class;
                synchronized (CircuitBreakerInterceptor.class) {
                    if (this.state == State.HALF_OPENED && this.successCount.incrementAndGet() >= 2) {
                        COSLogger.iNetwork("QCloudHttp", "CircuitBreaker is CLOSED.");
                        this.state = State.CLOSED;
                        this.failedCount.set(0);
                    } else if (this.state == State.OPEN) {
                        COSLogger.iNetwork("QCloudHttp", "CircuitBreaker is HALF_OPENED.");
                        this.state = State.HALF_OPENED;
                        this.successCount.set(1);
                    } else if (this.state == State.CLOSED) {
                        int f = this.failedCount.get();
                        if (f > 0) {
                            this.failedCount.set(Math.max(f - 2, 0));
                        }
                        COSLogger.iNetwork("QCloudHttp", "CircuitBreaker get success");
                    }
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return response;
                }
            }
            catch (IOException e) {
                Class<CircuitBreakerInterceptor> clazz3 = CircuitBreakerInterceptor.class;
                synchronized (CircuitBreakerInterceptor.class) {
                    this.recentErrorTimestamp = System.nanoTime();
                    if (this.state == State.CLOSED && this.failedCount.incrementAndGet() >= 5) {
                        COSLogger.iNetwork("QCloudHttp", "CircuitBreaker is OPEN.");
                        this.state = State.OPEN;
                        this.entryOpenStateTimestamp = System.nanoTime();
                    } else if (this.state == State.HALF_OPENED) {
                        COSLogger.iNetwork("QCloudHttp", "CircuitBreaker is OPEN.");
                        this.state = State.OPEN;
                        this.entryOpenStateTimestamp = System.nanoTime();
                    } else {
                        COSLogger.iNetwork("QCloudHttp", "CircuitBreaker get fail: %d", this.failedCount.get());
                    }
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                    throw e;
                }
            }
        }
    }

    private static class FootprintWriter {
        private Set<String> tasks = new HashSet<String>();

        private FootprintWriter() {
        }

        boolean noRecords(HttpTask task) {
            return !this.tasks.contains(this.getResourceId(task));
        }

        void remember(HttpTask task) {
            this.tasks.add(this.getResourceId(task));
        }

        String getResourceId(HttpTask task) {
            HttpRequest request = task.request();
            return request.method() + request.url().getHost() + "/" + request.url().getPath();
        }
    }

    static enum State {
        OPEN,
        CLOSED,
        HALF_OPENED;

    }
}

