/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CountingInputStream;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.io.InputStream;

public class ResponseInputStreamConverter<T>
extends ResponseBodyConverter<T>
implements ProgressBody {
    protected boolean isQuic = false;
    protected QCloudProgressListener progressListener;
    private CountingInputStream countingInputStream;

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void enableQuic(boolean isQuic) {
        this.isQuic = isQuic;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public T convert(HttpResponse<T> response) throws QCloudClientException, QCloudServiceException {
        if (this.isQuic) {
            return null;
        }
        HttpResponse.checkResponseSuccessful(response);
        String contentRangeString = response.header("Content-Range");
        long[] contentRange = QCloudHttpUtils.parseContentRange(contentRangeString);
        long contentLength = contentRange != null ? contentRange[1] - contentRange[0] + 1L : response.contentLength();
        this.countingInputStream = new CountingInputStream(response.byteStream(), contentLength, this.progressListener);
        return null;
    }

    @Override
    public long getBytesTransferred() {
        return this.countingInputStream != null ? this.countingInputStream.getTotalTransferred() : 0L;
    }

    public InputStream getInputStream() {
        return this.countingInputStream;
    }

    public long getBytesTotal() {
        return this.countingInputStream.getBytesTotal();
    }
}

