/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.ConnectionRepository;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.SelfCloseConverter;
import com.tencent.qcloud.core.util.OkhttpInternalUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.List;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpProxy<T>
extends NetworkProxy<T> {
    private Call httpCall;
    private Field eventListenerFiled;
    private OkHttpClient okHttpClient;

    public OkHttpProxy(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void cancel() {
        if (this.httpCall != null) {
            this.httpCall.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HttpResult<T> executeHttpRequest(HttpRequest<T> httpRequest) throws QCloudClientException, QCloudServiceException {
        HttpResult<T> httpResult;
        QCloudServiceException serviceException;
        QCloudClientException clientException;
        block19: {
            clientException = null;
            serviceException = null;
            Response response = null;
            CallMetricsListener eventListener = null;
            httpResult = null;
            boolean selfCloseConverter = httpRequest.getResponseBodyConverter() instanceof SelfCloseConverter;
            try {
                httpRequest.setOkHttpRequestTag(this.identifier);
                Request okHttpRequest = httpRequest.buildRealRequest();
                this.httpCall = this.okHttpClient.newCall(okHttpRequest);
                if (this.eventListenerFiled == null) {
                    try {
                        this.eventListenerFiled = this.httpCall.getClass().getDeclaredField("eventListener");
                        this.eventListenerFiled.setAccessible(true);
                        eventListener = (CallMetricsListener)((Object)this.eventListenerFiled.get(this.httpCall));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                response = this.httpCall.execute();
                if (eventListener != null) {
                    eventListener.dumpMetrics(this.metrics);
                }
                if (response != null) {
                    if (httpResult == null) {
                        httpResult = this.convertResponse(httpRequest, response);
                    }
                } else {
                    serviceException = new QCloudServiceException("http response is null");
                }
                if (response == null || selfCloseConverter) break block19;
            }
            catch (IOException e) {
                if (e.getCause() instanceof QCloudClientException) {
                    clientException = (QCloudClientException)e.getCause();
                    break block19;
                }
                if (e.getCause() instanceof QCloudServiceException) {
                    serviceException = (QCloudServiceException)e.getCause();
                    break block19;
                } else {
                    clientException = new QCloudClientException(e);
                }
                break block19;
            }
            OkhttpInternalUtils.closeQuietly((Closeable)response);
            break block19;
            finally {
                if (response != null && !selfCloseConverter) {
                    OkhttpInternalUtils.closeQuietly(response);
                }
            }
        }
        if (clientException != null) {
            throw clientException;
        }
        if (serviceException == null) return httpResult;
        throw serviceException;
    }

    @Override
    public Response callHttpRequest(Request okHttpRequest) throws IOException {
        return null;
    }

    private void recordDns(String host, CallMetricsListener eventListener) {
        List<InetAddress> dnsRecord = null;
        if (eventListener != null && (dnsRecord = eventListener.dumpDns()) != null) {
            ConnectionRepository.getInstance().insertDnsRecordCache(host, dnsRecord);
        }
    }

    private boolean isCosResponse(Response response) {
        return response != null && "tencent-cos".equalsIgnoreCase(response.header("Server"));
    }
}

