/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.HttpLogger;
import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.OkHttpProxy;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.interceptor.RedirectInterceptor;
import com.tencent.qcloud.core.http.interceptor.RetryInterceptor;
import com.tencent.qcloud.core.http.interceptor.TrafficControlInterceptor;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpClientImpl
extends NetworkClient {
    private EventListener.Factory mEventListenerFactory = new EventListener.Factory(){

        public EventListener create(Call call) {
            return new CallMetricsListener(call);
        }
    };
    private OkHttpClient okHttpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(QCloudHttpClient.Builder b, HostnameVerifier hostnameVerifier, Dns dns, HttpLogger httpLogger) {
        super.init(b, hostnameVerifier, dns, httpLogger);
        Object object = QCloudHttpClient.okHttpClientBuilderLock;
        synchronized (object) {
            HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor(httpLogger);
            logInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
            OkHttpClient.Builder builder = b.mBuilder;
            builder.interceptors().clear();
            RedirectInterceptor redirectInterceptor = new RedirectInterceptor();
            builder.followRedirects(false).followSslRedirects(true).hostnameVerifier(hostnameVerifier).dns(dns).connectTimeout((long)b.connectionTimeout, TimeUnit.MILLISECONDS).readTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).eventListenerFactory(this.mEventListenerFactory).addInterceptor((Interceptor)logInterceptor).addInterceptor((Interceptor)new RetryInterceptor(b.retryStrategy)).addInterceptor((Interceptor)new TrafficControlInterceptor());
            if (b.redirectEnable) {
                builder.addInterceptor((Interceptor)redirectInterceptor);
            }
            if (!b.verifySSLEnable) {
                try {
                    builder.hostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }};
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (b.clientCertificateBytes != null) {
                try {
                    KeyStore clientKeyStore = KeyStore.getInstance("BKS");
                    if (b.clientCertificateBytes == null) {
                        throw new IllegalStateException("No client certificate provided");
                    }
                    clientKeyStore.load(new ByteArrayInputStream(b.clientCertificateBytes), b.clientCertificatePassword);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(clientKeyStore, b.clientCertificatePassword);
                    KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                    TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(keyManagers, trustManagers, new SecureRandom());
                    builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.okHttpClient = builder.build();
            redirectInterceptor.setClient(this.okHttpClient);
        }
    }

    @Override
    public NetworkProxy getNetworkProxy() {
        OkHttpProxy okHttpProxy = new OkHttpProxy(this.okHttpClient);
        return okHttpProxy;
    }
}

