/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import java.net.URL;
import java.util.Locale;

public class COSXmlSigner
implements QCloudSigner {
    static final String COS_SESSION_TOKEN = "x-cos-security-token";

    @Override
    public void sign(QCloudHttpRequest request, QCloudCredentials credentials) throws QCloudClientException {
        if (credentials == null) {
            throw new QCloudClientException(new QCloudAuthenticationException("Credentials is null."));
        }
        COSXmlSignSourceProvider sourceProvider = (COSXmlSignSourceProvider)request.getSignProvider();
        if (sourceProvider == null) {
            throw new QCloudClientException(new QCloudAuthenticationException("No sign provider for cos xml signer."));
        }
        StringBuilder authorization = new StringBuilder();
        QCloudLifecycleCredentials lifecycleCredentials = (QCloudLifecycleCredentials)credentials;
        String keyTime = request.getKeyTime();
        if (keyTime == null) {
            keyTime = lifecycleCredentials.getKeyTime();
        }
        sourceProvider.setSignTime(keyTime);
        String signature = this.signature(sourceProvider.source(request), lifecycleCredentials.getSignKey());
        authorization.append("q-sign-algorithm").append("=").append("sha1").append("&").append("q-ak").append("=").append(credentials.getSecretId()).append("&").append("q-sign-time").append("=").append(keyTime).append("&").append("q-key-time").append("=").append(lifecycleCredentials.getKeyTime()).append("&").append("q-header-list").append("=").append(sourceProvider.getRealHeaderList().toLowerCase(Locale.ROOT)).append("&").append("q-url-param-list").append("=").append(sourceProvider.getRealParameterList().toLowerCase(Locale.ROOT)).append("&").append("q-signature").append("=").append(signature);
        String auth = authorization.toString();
        if (request.isSignInUrl()) {
            this.addAuthInPara(request, credentials, auth);
        } else {
            this.addAuthInHeader(request, credentials, auth);
        }
        sourceProvider.onSignRequestSuccess(request, credentials, auth);
    }

    private void addAuthInPara(QCloudHttpRequest request, QCloudCredentials credentials, String auth) {
        URL url = request.url();
        String authQuery = auth;
        if (credentials instanceof SessionQCloudCredentials) {
            SessionQCloudCredentials sessionCredentials = (SessionQCloudCredentials)credentials;
            authQuery = authQuery.concat("&token").concat("=").concat(sessionCredentials.getToken());
        }
        String query = url.getQuery();
        String sUrl = url.toString();
        int index = sUrl.indexOf(63);
        if (index < 0) {
            sUrl = sUrl.concat("?").concat(authQuery);
        } else {
            int lastQueryIndex = index + query.length();
            sUrl = sUrl.substring(0, lastQueryIndex + 1).concat("&").concat(authQuery).concat(sUrl.substring(lastQueryIndex + 1));
        }
        request.setUrl(sUrl);
    }

    protected String getSessionTokenKey() {
        return COS_SESSION_TOKEN;
    }

    private void addAuthInHeader(QCloudHttpRequest request, QCloudCredentials credentials, String auth) {
        request.removeHeader("Authorization");
        request.addHeader("Authorization", auth);
        if (credentials instanceof SessionQCloudCredentials) {
            SessionQCloudCredentials sessionCredentials = (SessionQCloudCredentials)credentials;
            String sessionTokenKey = this.getSessionTokenKey();
            request.removeHeader(sessionTokenKey);
            request.addHeader(sessionTokenKey, sessionCredentials.getToken());
        }
    }

    private String signature(String source, String signKey) {
        byte[] sha1Bytes = Utils.hmacSha1(source, signKey);
        String signature = "";
        if (sha1Bytes != null) {
            signature = new String(Utils.encodeHex(sha1Bytes));
        }
        return signature;
    }
}

