/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import com.tencent.cos.xml.utils.CRC64;
import java.io.IOException;
import java.io.InputStream;

public class CRC64Calculator {
    private static final long POLY = -3932672073523589310L;
    private static final long INIT = -1L;
    private static final int GF2_DIM = 64;

    public static long getCRC64(InputStream inputStream, long skip, long size) throws IOException {
        int needRead;
        long totalRead;
        int readLen;
        long skipped;
        for (long remaining = skip; remaining > 0L; remaining -= skipped) {
            skipped = inputStream.skip(remaining);
            if (skipped > 0L) continue;
            throw new IOException("Failed to skip " + skip + " bytes");
        }
        CRC64 crc64 = new CRC64();
        byte[] buff = new byte[8192];
        for (totalRead = 0L; totalRead < size && (readLen = inputStream.read(buff, 0, needRead = (int)Math.min(size - totalRead, (long)buff.length))) != -1; totalRead += (long)readLen) {
            crc64.update(buff, 0, readLen);
        }
        if (totalRead != size) {
            throw new IOException("Expected to read " + size + " bytes but got " + totalRead);
        }
        return crc64.getValue();
    }

    public static long combine(long crc1, long crc2, long len2) {
        if (len2 == 0L) {
            return crc1;
        }
        crc1 = crc1 ^ 0xFFFFFFFFFFFFFFFFL ^ 0xFFFFFFFFFFFFFFFFL;
        crc2 ^= 0xFFFFFFFFFFFFFFFFL;
        long[] mat = new long[64];
        long[] even = new long[64];
        long[] odd = new long[64];
        mat[0] = -3932672073523589310L;
        long val = 1L;
        for (int i = 1; i < 64; ++i) {
            mat[i] = val;
            val <<= 1;
        }
        CRC64Calculator.gf2MatrixSquare(even, mat);
        CRC64Calculator.gf2MatrixSquare(odd, even);
        long len = len2;
        do {
            CRC64Calculator.gf2MatrixSquare(even, odd);
            if ((len & 1L) != 0L) {
                crc1 = CRC64Calculator.gf2MatrixTimes(even, crc1);
            }
            if ((len >>>= 1) == 0L) break;
            CRC64Calculator.gf2MatrixSquare(odd, even);
            if ((len & 1L) == 0L) continue;
            crc1 = CRC64Calculator.gf2MatrixTimes(odd, crc1);
        } while ((len >>>= 1) != 0L);
        return crc1 ^ crc2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static long gf2MatrixTimes(long[] mat, long vec) {
        long sum = 0L;
        int index = 0;
        while (vec != 0L) {
            if ((vec & 1L) != 0L) {
                sum ^= mat[index];
            }
            vec >>>= 1;
            ++index;
        }
        return sum;
    }

    private static void gf2MatrixSquare(long[] square, long[] mat) {
        for (int n = 0; n < 64; ++n) {
            square[n] = CRC64Calculator.gf2MatrixTimes(mat, mat[n]);
        }
    }
}

