/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.CosTrackService;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.utils.COSUtils;
import com.tencent.cos.xml.utils.CRC64Calculator;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.FileUtils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.logger.COSLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class COSXMLDownloadTask
extends COSXMLTask {
    private static final String TAG = COSXMLDownloadTask.class.getSimpleName();
    private String localSaveDirPath;
    private String localSaveFileName;
    private static final long CRC_CHECK_INTERVAL = 0xA00000L;
    private static final int MAX_RETRY = 3;
    private boolean crc64CheckEnabled = true;
    private String serverCrc64;
    private Map<Long, Long> crc64Map = new ConcurrentHashMap<Long, Long>();
    private long lastCrcCheckPosition = 0L;
    private int retryCount = 0;
    private ExecutorService crcExecutor = Executors.newSingleThreadExecutor();
    private CountDownLatch crcLatch = new CountDownLatch(1);
    private long rangeStart = 0L;
    private long rangeEnd = -1L;
    private long fileOffset = 0L;
    private boolean objectKeySimplifyCheck = true;
    private String eTag;
    private long hasWriteDataLen = 0L;
    private long startTime = 0L;
    private HeadObjectRequest headObjectRequest;
    private GetObjectRequest getObjectRequest;
    private SharedPreferences sharedPreferences;
    private String clientTraceId;

    COSXMLDownloadTask(Context context, CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, String localSaveDirPath, String localSaveFileName) {
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.localSaveDirPath = localSaveDirPath;
        this.localSaveFileName = localSaveFileName;
        this.cosXmlService = cosXmlService;
        if (context != null) {
            this.sharedPreferences = context.getSharedPreferences("COSXMLDOWNLOADTASK", 0);
        }
        this.clientTraceId = UUID.randomUUID().toString();
    }

    COSXMLDownloadTask(Context context, CosXmlSimpleService cosXmlService, GetObjectRequest getObjectRequest) {
        this(context, cosXmlService, getObjectRequest.getRegion(), getObjectRequest.getBucket(), getObjectRequest.getPath(cosXmlService.getConfig()), getObjectRequest.getSavePath(), getObjectRequest.getSaveFileName());
        this.queries = getObjectRequest.getQueryString();
        this.headers = getObjectRequest.getRequestHeaders();
        this.noSignHeaders = getObjectRequest.getNoSignHeaders();
        this.networkType = getObjectRequest.getNetworkType();
        this.host = getObjectRequest.getHost();
        this.credentialProvider = getObjectRequest.getCredentialProvider();
        this.objectKeySimplifyCheck = getObjectRequest.isObjectKeySimplifyCheck();
        this.isNeedMd5 = getObjectRequest.isNeedMD5();
        if (this.headers != null && this.headers.containsKey("Range")) {
            List ranges = (List)this.headers.get("Range");
            String range = (String)ranges.get(0);
            int index1 = range.indexOf("=");
            int index2 = range.indexOf("-");
            this.rangeStart = Long.valueOf(range.substring(index1 + 1, index2));
            String end = range.substring(index2 + 1);
            if (!TextUtils.isEmpty((CharSequence)end)) {
                this.rangeEnd = Long.valueOf(end);
            }
            this.crc64CheckEnabled = false;
        }
        this.fileOffset = getObjectRequest.getFileOffset();
    }

    private boolean checkParameter() {
        if (this.objectKeySimplifyCheck) {
            String normalizedPath = this.cosPath;
            try {
                File file = new File("/" + this.cosPath);
                normalizedPath = file.getCanonicalPath();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if ("/".equals(normalizedPath)) {
                this.updateState(TransferState.FAILED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "The key in the getobject is illegal")), null, false);
                return false;
            }
        }
        return true;
    }

    protected void download() {
        if (!this.checkParameter()) {
            return;
        }
        this.startTime = System.nanoTime();
        this.clientTraceId = UUID.randomUUID().toString();
        this.run();
    }

    private void realDownload(long rangeStart, long rangeEnd, long fileOffset) {
        this.getObjectRequest = new GetObjectRequest(this.bucket, this.cosPath, this.localSaveDirPath, this.localSaveFileName);
        this.getObjectRequest.setRegion(this.region);
        this.getObjectRequest.setFileOffset(fileOffset);
        this.getObjectRequest.setQueryParameters(this.queries);
        this.getObjectRequest.setRequestHeaders(this.headers);
        this.getObjectRequest.setObjectKeySimplifyCheck(this.objectKeySimplifyCheck);
        this.getObjectRequest.addNoSignHeader(this.noSignHeaders);
        this.getObjectRequest.setNetworkType(this.networkType);
        this.getObjectRequest.setHost(this.host);
        this.getObjectRequest.setCredentialProvider(this.credentialProvider);
        if (rangeEnd > 0L || rangeStart > 0L) {
            this.getObjectRequest.setRange(rangeStart, rangeEnd);
        }
        if (this.onSignatureListener != null) {
            this.getObjectRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.getObjectRequest));
        }
        this.getHttpMetrics((CosXmlRequest)this.getObjectRequest, "GetObjectRequest");
        this.getObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                long currentPosition = COSXMLDownloadTask.this.hasWriteDataLen + complete;
                if (COSXMLDownloadTask.this.crc64CheckEnabled && (currentPosition - COSXMLDownloadTask.this.lastCrcCheckPosition >= 0xA00000L || complete == target && currentPosition > COSXMLDownloadTask.this.lastCrcCheckPosition)) {
                    COSLogger.dProcess((String)TAG, (String)("calculateFileCrc start: " + COSXMLDownloadTask.this.lastCrcCheckPosition + " end: " + currentPosition));
                    long start = COSXMLDownloadTask.this.lastCrcCheckPosition;
                    COSXMLDownloadTask.this.lastCrcCheckPosition = currentPosition;
                    COSXMLDownloadTask.this.calculateFileCrc(start, currentPosition, complete == target);
                }
                if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                    COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(currentPosition, COSXMLDownloadTask.this.hasWriteDataLen + target);
                }
            }
        });
        this.getObjectRequest.setClientTraceId(this.clientTraceId);
        this.cosXmlService.internalGetObjectAsync(this.getObjectRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLDownloadTask.this.getObjectRequest) {
                    return;
                }
                if (COSXMLDownloadTask.this.crc64CheckEnabled) {
                    COSXMLDownloadTask.this.serverCrc64 = result.getHeader("x-cos-hash-crc64ecma");
                    COSLogger.dProcess((String)TAG, (String)("serverCrc64: " + COSXMLDownloadTask.this.serverCrc64));
                }
                try {
                    COSXMLDownloadTask.this.crcLatch.await();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    COSXMLDownloadTask.this.handleCrcCheckFailure();
                    return;
                }
                if (COSXMLDownloadTask.this.crc64CheckEnabled && !COSXMLDownloadTask.this.validateCrc64()) {
                    COSXMLDownloadTask.this.handleCrcCheckFailure();
                    return;
                }
                CosTrackService.getInstance().reportDownloadTaskSuccess((CosXmlRequest)COSXMLDownloadTask.this.getObjectRequest, COSXMLDownloadTask.this.getCosXmlServiceConfigTrackParams());
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLDownloadTask.this.IS_EXIT.set(true);
                COSXMLDownloadTask.this.updateState(TransferState.COMPLETED, null, result, false);
            }

            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (request != COSXMLDownloadTask.this.getObjectRequest) {
                    return;
                }
                Throwable causeException = null;
                if (clientException != null && COSXMLDownloadTask.this.taskState != TransferState.PAUSED && COSXMLDownloadTask.this.taskState != TransferState.CANCELED) {
                    CosTrackService.getInstance().reportDownloadTaskClientException(request, (QCloudClientException)((Object)clientException), COSXMLDownloadTask.this.getCosXmlServiceConfigTrackParams());
                    causeException = clientException;
                }
                if (serviceException != null && COSXMLDownloadTask.this.taskState != TransferState.PAUSED && COSXMLDownloadTask.this.taskState != TransferState.CANCELED) {
                    CosTrackService.getInstance().reportDownloadTaskServiceException(request, (QCloudServiceException)serviceException, COSXMLDownloadTask.this.getCosXmlServiceConfigTrackParams());
                    causeException = serviceException;
                }
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLDownloadTask.this.IS_EXIT.set(true);
                COSXMLDownloadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
            }
        });
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest() {
        COSXMLDownloadTaskRequest cosxmlDownloadTaskRequest = new COSXMLDownloadTaskRequest(this.region, this.bucket, this.cosPath, this.localSaveDirPath, this.localSaveFileName, this.headers, this.queries);
        return cosxmlDownloadTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLDownloadTaskResult cosxmlDownloadTaskResult = new COSXMLDownloadTaskResult();
        if (sourceResult != null) {
            cosxmlDownloadTaskResult.httpCode = sourceResult.httpCode;
            cosxmlDownloadTaskResult.httpMessage = sourceResult.httpMessage;
            cosxmlDownloadTaskResult.headers = sourceResult.headers;
            cosxmlDownloadTaskResult.eTag = this.eTag;
            cosxmlDownloadTaskResult.accessUrl = sourceResult.accessUrl;
        }
        return cosxmlDownloadTaskResult;
    }

    private String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("download").append("_").append(this.region).append("_").append(this.bucket).append("_").append(this.cosPath).append("_").append(this.rangeStart).append("_").append(this.rangeEnd).append("_").append(this.fileOffset).append("_").append(this.localSaveDirPath).append("_").append(this.localSaveFileName).append("_").append(this.eTag);
        try {
            return DigestUtils.getSha1((String)stringBuffer.toString());
        }
        catch (CosXmlClientException e2) {
            return stringBuffer.toString();
        }
    }

    private synchronized String hasExisted() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(this.getKey(), null);
        }
        return null;
    }

    private synchronized void clear() {
        if (this.sharedPreferences != null) {
            SharedPreferences.Editor editor = this.sharedPreferences.edit();
            editor.remove(this.getKey());
            editor.remove(this.getKey() + "_crc");
            editor.commit();
        }
    }

    private void cancelAllRequest(boolean now) {
        HeadObjectRequest tempHeadObjectRequest = this.headObjectRequest;
        this.cosXmlService.cancel((CosXmlRequest)tempHeadObjectRequest, now);
        GetObjectRequest tempGetObjectRequest = this.getObjectRequest;
        this.cosXmlService.cancel((CosXmlRequest)tempGetObjectRequest, now);
    }

    private synchronized void save(String absolutePath) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(this.getKey(), absolutePath).commit();
        }
    }

    private void calculateFileCrc(long start, long end, boolean isLast) {
        this.crcExecutor.execute(() -> {
            try {
                File file = new File(this.getDownloadPath());
                long crcValue = CRC64Calculator.getCRC64((InputStream)new FileInputStream(file), (long)start, (long)(end - start));
                this.crc64Map.put(start, crcValue);
                COSXMLDownloadTask cOSXMLDownloadTask = this;
                synchronized (cOSXMLDownloadTask) {
                    if (this.sharedPreferences != null) {
                        SharedPreferences.Editor editor = this.sharedPreferences.edit();
                        editor.putString(this.getKey() + "_crc", this.serializeCrcMap());
                        editor.apply();
                    }
                }
                COSLogger.dProcess((String)TAG, (String)("calculateFileCrc finish start: " + start + " end: " + end + " crcValue= " + crcValue));
                if (isLast) {
                    this.crcLatch.countDown();
                }
            }
            catch (IOException e2) {
                COSLogger.wProcess((String)TAG, (String)("CRC64 calculation error: " + e2.getMessage()));
                this.handleCrcCheckFailure();
            }
        });
    }

    private boolean validateCrc64() {
        if (TextUtils.isEmpty((CharSequence)this.serverCrc64)) {
            return true;
        }
        try {
            String mergedCrc = this.mergeCrcValues();
            COSLogger.dProcess((String)TAG, (String)("mergedCrc= " + mergedCrc));
            return mergedCrc.equals(this.serverCrc64);
        }
        catch (Exception e2) {
            COSLogger.wProcess((String)TAG, (String)("MergeCRC64 validation error: " + e2.getMessage()));
            return false;
        }
    }

    private String mergeCrcValues() {
        Object[] sortedKeys = this.crc64Map.keySet().toArray(new Long[0]);
        Arrays.sort(sortedKeys);
        COSLogger.dProcess((String)TAG, (String)("crc64Map sortedKeys= " + Arrays.toString(sortedKeys) + " lastCrcCheckPosition= " + this.lastCrcCheckPosition));
        long mergedCrc = new BigInteger(Long.toUnsignedString(this.crc64Map.get(sortedKeys[0]), 10).trim()).longValue();
        for (int i2 = 1; i2 < sortedKeys.length; ++i2) {
            long start = (Long)sortedKeys[i2];
            long blockLength = i2 == sortedKeys.length - 1 ? this.lastCrcCheckPosition - start : (Long)sortedKeys[i2 + 1] - start;
            long crc2 = new BigInteger(Long.toUnsignedString(this.crc64Map.get(start), 10).trim()).longValue();
            mergedCrc = CRC64Calculator.combine((long)mergedCrc, (long)crc2, (long)blockLength);
        }
        return Long.toUnsignedString(mergedCrc);
    }

    private void handleCrcCheckFailure() {
        COSLogger.wProcess((String)TAG, (String)("CRC64 check failed:" + this.retryCount));
        if (this.retryCount++ < 3) {
            this.crcExecutor.shutdownNow();
            if (!FileUtils.deleteFileIfExist((String)this.getDownloadPath())) {
                this.updateState(TransferState.FAILED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), "CRC64 check failed")), null, false);
                return;
            }
            this.clear();
            this.crc64Map.clear();
            this.lastCrcCheckPosition = 0L;
            this.IS_EXIT.set(false);
            this.crcExecutor = Executors.newSingleThreadExecutor();
            this.crcLatch = new CountDownLatch(1);
            this.download();
        } else {
            this.updateState(TransferState.FAILED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), "CRC64 check failed")), null, false);
        }
    }

    private boolean validatePartialCrc(File file, long checkLength) throws IOException {
        if (checkLength <= 0L) {
            return true;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            long segmentSize = 0xA00000L;
            long position = 0L;
            while (position < checkLength) {
                long end = Math.min(position + segmentSize, checkLength);
                long crcValue = CRC64Calculator.getCRC64((InputStream)fis, (long)position, (long)(end - position));
                Long savedCrc = this.crc64Map.get(position);
                if (savedCrc == null || savedCrc != crcValue) {
                    boolean bl = false;
                    return bl;
                }
                position = end;
            }
            boolean bl = true;
            return bl;
        }
    }

    private String serializeCrcMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, Long> entry : this.crc64Map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return sb.toString();
    }

    private void deserializeCrcMap(String data) {
        String[] entries;
        this.crc64Map.clear();
        if (TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        for (String entry : entries = data.split(",")) {
            String[] parts = entry.split(":");
            if (parts.length != 2) continue;
            try {
                long key = Long.parseLong(parts[0]);
                long value = Long.parseLong(parts[1]);
                this.crc64Map.put(key, value);
            }
            catch (NumberFormatException e2) {
                COSLogger.wProcess((String)TAG, (String)("Failed to parse CRC64 entry: " + entry));
            }
        }
    }

    private long crc64MapLastKey() {
        long last = 0L;
        for (Long key : this.crc64Map.keySet()) {
            if (key <= last) continue;
            last = key;
        }
        return last;
    }

    private String getDownloadPath() {
        String path = null;
        if (this.localSaveDirPath != null) {
            path = !this.localSaveDirPath.endsWith("/") ? this.localSaveDirPath + "/" : this.localSaveDirPath;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.localSaveFileName != null) {
                path = path + this.localSaveFileName;
                return path;
            }
            if (this.cosPath != null) {
                int separator = this.cosPath.lastIndexOf("/");
                path = separator >= 0 ? path + this.cosPath.substring(separator + 1) : path + this.cosPath;
            }
        }
        return path;
    }

    protected void run() {
        this.headObjectRequest = new HeadObjectRequest(this.bucket, this.cosPath);
        this.headObjectRequest.setRequestHeaders(this.headers);
        this.headObjectRequest.addNoSignHeader(this.noSignHeaders);
        this.headObjectRequest.setNetworkType(this.networkType);
        this.headObjectRequest.setHost(this.host);
        this.headObjectRequest.setCredentialProvider(this.credentialProvider);
        this.headObjectRequest.setQueryParameters(this.queries);
        this.headObjectRequest.setRegion(this.region);
        final String downloadPath = this.getDownloadPath();
        if (this.onSignatureListener != null) {
            this.headObjectRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.headObjectRequest));
        }
        this.getHttpMetrics((CosXmlRequest)this.headObjectRequest, "HeadObjectRequest");
        this.headObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (state != 1) {
                    COSXMLDownloadTask.this.updateState(TransferState.IN_PROGRESS, null, null, false);
                }
            }
        });
        this.headObjectRequest.setClientTraceId(this.clientTraceId);
        this.cosXmlService.headObjectAsync(this.headObjectRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                File file;
                String absolutePath;
                if (request != COSXMLDownloadTask.this.headObjectRequest) {
                    return;
                }
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                List eTags = (List)result.headers.get("ETag");
                if (eTags != null && eTags.size() > 0) {
                    COSXMLDownloadTask.this.eTag = (String)eTags.get(0);
                }
                if ((absolutePath = COSXMLDownloadTask.this.hasExisted()) != null && (file = new File(absolutePath)).exists()) {
                    String savedCrc = COSXMLDownloadTask.this.sharedPreferences.getString(COSXMLDownloadTask.this.getKey() + "_crc", null);
                    COSXMLDownloadTask.this.crc64CheckEnabled = !TextUtils.isEmpty((CharSequence)savedCrc);
                    long fileLength = file.length();
                    if (savedCrc != null && COSXMLDownloadTask.this.crc64CheckEnabled) {
                        long lastCrcPosition;
                        COSXMLDownloadTask.this.deserializeCrcMap(savedCrc);
                        long l2 = lastCrcPosition = COSXMLDownloadTask.this.crc64Map.isEmpty() ? 0L : COSXMLDownloadTask.this.crc64MapLastKey();
                        if (fileLength > lastCrcPosition) {
                            COSLogger.dProcess((String)TAG, (String)"Local file is longer than CRC records, will truncate to last valid position");
                            if (!FileUtils.truncateFile((File)file, (long)lastCrcPosition)) {
                                COSLogger.dProcess((String)TAG, (String)"File truncate failed, will handle as failure");
                                COSXMLDownloadTask.this.handleCrcCheckFailure();
                                return;
                            }
                            try {
                                if (!COSXMLDownloadTask.this.validatePartialCrc(file, lastCrcPosition)) {
                                    COSLogger.dProcess((String)TAG, (String)"CRC check failed for existing file");
                                    COSXMLDownloadTask.this.handleCrcCheckFailure();
                                    return;
                                }
                            }
                            catch (IOException e2) {
                                COSLogger.wProcess((String)TAG, (String)("CRC validation error: " + e2.getMessage()));
                                COSXMLDownloadTask.this.handleCrcCheckFailure();
                                return;
                            }
                        }
                        if (fileLength < lastCrcPosition) {
                            COSLogger.dProcess((String)TAG, (String)"Local file is shorter than CRC records");
                            COSXMLDownloadTask.this.handleCrcCheckFailure();
                            return;
                        }
                        try {
                            if (!COSXMLDownloadTask.this.validatePartialCrc(file, lastCrcPosition)) {
                                COSLogger.dProcess((String)TAG, (String)"CRC check failed for existing file");
                                COSXMLDownloadTask.this.handleCrcCheckFailure();
                                return;
                            }
                        }
                        catch (IOException e3) {
                            COSLogger.wProcess((String)TAG, (String)("CRC validation error: " + e3.getMessage()));
                            COSXMLDownloadTask.this.handleCrcCheckFailure();
                            return;
                        }
                        List contentLengths = (List)result.headers.get("Content-Length");
                        if (contentLengths != null && contentLengths.size() > 0 && Long.valueOf((String)contentLengths.get(0)) == fileLength) {
                            if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                                COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(fileLength, fileLength);
                            }
                            COSXMLDownloadTask.this.IS_EXIT.set(true);
                            COSXMLDownloadTask.this.updateState(TransferState.COMPLETED, null, result, false);
                            return;
                        }
                        COSXMLDownloadTask.this.hasWriteDataLen = lastCrcPosition - COSXMLDownloadTask.this.fileOffset;
                        COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart + COSXMLDownloadTask.this.hasWriteDataLen, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset + COSXMLDownloadTask.this.hasWriteDataLen);
                        return;
                    }
                    List contentLengths = (List)result.headers.get("Content-Length");
                    if (contentLengths != null && contentLengths.size() > 0 && Long.valueOf((String)contentLengths.get(0)) == fileLength) {
                        if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                            COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(fileLength, fileLength);
                        }
                        COSXMLDownloadTask.this.IS_EXIT.set(true);
                        COSXMLDownloadTask.this.updateState(TransferState.COMPLETED, null, result, false);
                        return;
                    }
                    COSXMLDownloadTask.this.hasWriteDataLen = fileLength - COSXMLDownloadTask.this.fileOffset;
                    COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart + COSXMLDownloadTask.this.hasWriteDataLen, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset + COSXMLDownloadTask.this.hasWriteDataLen);
                    return;
                }
                FileUtils.deleteFileIfExist((String)downloadPath);
                COSXMLDownloadTask.this.save(COSXMLDownloadTask.this.getDownloadPath());
                COSXMLDownloadTask.this.hasWriteDataLen = 0L;
                COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset);
            }

            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (request != COSXMLDownloadTask.this.headObjectRequest) {
                    return;
                }
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                Throwable causeException = clientException == null ? serviceException : clientException;
                causeException.printStackTrace();
                COSXMLDownloadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
                COSLogger.iProcess((String)TAG, (String)("head " + COSXMLDownloadTask.this.cosPath + "failed !, exception is " + causeException.getMessage()), (Throwable)causeException);
            }
        });
    }

    @Override
    protected void internalCompleted() {
        this.clear();
    }

    @Override
    protected void internalFailed() {
        this.cancelAllRequest(false);
    }

    @Override
    protected void internalPause(boolean now) {
        if (this.getObjectRequest != null) {
            CosTrackService.getInstance().reportDownloadTaskSuccess((CosXmlRequest)this.getObjectRequest, this.getCosXmlServiceConfigTrackParams());
        }
        this.cancelAllRequest(now);
    }

    @Override
    protected void internalCancel(boolean now) {
        this.cancelAllRequest(now);
        this.clear();
    }

    @Override
    protected void internalResume() {
        this.taskState = TransferState.WAITING;
        this.IS_EXIT.set(false);
        this.download();
    }

    @Override
    protected void encounterError(@Nullable CosXmlRequest cosXmlRequest, CosXmlClientException clientException, CosXmlServiceException serviceException) {
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        this.updateState(TransferState.FAILED, COSUtils.mergeException(clientException, serviceException), null, false);
    }

    public static class COSXMLDownloadTaskResult
    extends CosXmlResult {
        public String eTag;

        protected COSXMLDownloadTaskResult() {
        }
    }

    public static class COSXMLDownloadTaskRequest
    extends GetObjectRequest {
        protected COSXMLDownloadTaskRequest(String region, String bucket, String cosPath, String savePath, String saveFileName, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, savePath, saveFileName);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }
}

