/*
 * Decompiled with CFR 0.152.
 */
package com.q42.qlassified;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.q42.qlassified.Entry.QlassifiedBoolean;
import com.q42.qlassified.Entry.QlassifiedFloat;
import com.q42.qlassified.Entry.QlassifiedInteger;
import com.q42.qlassified.Entry.QlassifiedLong;
import com.q42.qlassified.Entry.QlassifiedSerializable;
import com.q42.qlassified.Entry.QlassifiedString;
import com.q42.qlassified.QlassifiedFactory;
import com.q42.qlassified.Storage.QlassifiedStorageService;
import java.io.Serializable;

public enum Qlassified {
    Service;

    private final QlassifiedFactory classifiedFactory = new QlassifiedFactory();

    public void start(Context context) {
        this.classifiedFactory.create(context);
    }

    public void setStorageService(@NonNull QlassifiedStorageService service) {
        if (service == null) {
            Log.e((String)"Qlassified", (String)"Storage service prodided is null");
            return;
        }
        this.classifiedFactory.setStorageService(service);
    }

    public Boolean getBoolean(@NonNull String key) {
        return this.classifiedFactory.getBoolean(key);
    }

    public Float getFloat(@NonNull String key) {
        return this.classifiedFactory.getFloat(key);
    }

    public Integer getInt(@NonNull String key) {
        return this.classifiedFactory.getInt(key);
    }

    public Long getLong(@NonNull String key) {
        return this.classifiedFactory.getLong(key);
    }

    public String getString(@NonNull String key) {
        return this.classifiedFactory.getString(key);
    }

    public Serializable getSerializable(@NonNull String key) {
        return this.classifiedFactory.getSerializable(key);
    }

    public boolean put(@NonNull String key, @NonNull Boolean booleanValue) {
        return this.classifiedFactory.put(new QlassifiedBoolean(key, booleanValue));
    }

    public boolean put(@NonNull String key, @NonNull Float floatValue) {
        return this.classifiedFactory.put(new QlassifiedFloat(key, floatValue));
    }

    public boolean put(@NonNull String key, @NonNull Integer integerValue) {
        return this.classifiedFactory.put(new QlassifiedInteger(key, integerValue));
    }

    public boolean put(@NonNull String key, @NonNull Long longValue) {
        return this.classifiedFactory.put(new QlassifiedLong(key, longValue));
    }

    public boolean put(@NonNull String key, @NonNull String stringValue) {
        return this.classifiedFactory.put(new QlassifiedString(key, stringValue));
    }

    public boolean put(@NonNull String key, @NonNull Serializable serializableValue) {
        return this.classifiedFactory.put(new QlassifiedSerializable(key, serializableValue));
    }
}

