/*
 * Decompiled with CFR 0.152.
 */
package com.q42.qlassified.Provider;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.q42.qlassified.Entry.EncryptedEntry;
import com.q42.qlassified.Entry.QlassifiedBoolean;
import com.q42.qlassified.Entry.QlassifiedEntry;
import com.q42.qlassified.Entry.QlassifiedFloat;
import com.q42.qlassified.Entry.QlassifiedInteger;
import com.q42.qlassified.Entry.QlassifiedLong;
import com.q42.qlassified.Entry.QlassifiedString;
import com.q42.qlassified.Provider.QlassifiedCrypto;
import com.q42.qlassified.Provider.QlassifiedSecurity;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;

@TargetApi(value=18)
public class QlassifiedKeyStore
implements QlassifiedSecurity {
    public static final String ANDROID_KEYSTORE_INSTANCE = "AndroidKeyStore";
    public static final String TYPE_DELIMITER = "|";
    private final KeyStore keyStoreInstance = KeyStore.getInstance("AndroidKeyStore");
    private final QlassifiedCrypto crypto;
    private final Context context;

    public QlassifiedKeyStore(Context context) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.keyStoreInstance.load(null);
        this.context = context;
        this.crypto = new QlassifiedCrypto();
    }

    private void createKeys() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        KeyPairGenerator keyPairGenerator;
        String alias = this.getUniqueDeviceId(this.context);
        if (Build.VERSION.SDK_INT >= 23) {
            keyPairGenerator = KeyPairGenerator.getInstance("EC", ANDROID_KEYSTORE_INSTANCE);
            keyPairGenerator.initialize((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(alias, 4).setAlgorithmParameterSpec((AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1")).setDigests(new String[]{"SHA-256", "SHA-384", "SHA-512"}).build());
        } else {
            GregorianCalendar start = new GregorianCalendar();
            GregorianCalendar end = new GregorianCalendar();
            ((Calendar)end).add(0, 1);
            KeyPairGeneratorSpec keyPairGeneratorSpec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(alias).setSubject(new X500Principal("CN=" + alias)).setSerialNumber(BigInteger.valueOf(1337L)).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE_INSTANCE);
            keyPairGenerator.initialize((AlgorithmParameterSpec)keyPairGeneratorSpec);
        }
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Log.d((String)"KeyStore", (String)String.format("Public key: %s", keyPair.getPublic()));
        Log.d((String)"KeyStore", (String)String.format("Private key: %s", keyPair.getPrivate()));
    }

    private String getUniqueDeviceId(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String tmDevice = "" + tm.getDeviceId();
        String tmSerial = "" + tm.getSimSerialNumber();
        String androidId = "" + Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        UUID deviceUuid = new UUID(androidId.hashCode(), (long)tmDevice.hashCode() << 32 | (long)tmSerial.hashCode());
        return deviceUuid.toString();
    }

    @Override
    public EncryptedEntry encryptEntry(QlassifiedEntry classifiedEntry) {
        return new EncryptedEntry(classifiedEntry.getKey(), this.encrypt(String.format(String.format("%s%s%s", "%s", TYPE_DELIMITER, "%s"), classifiedEntry.getValue(), classifiedEntry.getType().name())));
    }

    @Override
    public QlassifiedEntry decryptEntry(EncryptedEntry entry) {
        String decryptedString = this.decrypt(entry.getEncryptedValue());
        if (decryptedString == null) {
            return null;
        }
        Integer splitPosition = decryptedString.lastIndexOf(TYPE_DELIMITER);
        if (splitPosition == -1) {
            return null;
        }
        String decryptedType = decryptedString.substring(splitPosition + 1);
        String decryptedValue = decryptedString.substring(0, splitPosition);
        switch (QlassifiedEntry.Type.valueOf(decryptedType)) {
            case BOOLEAN: {
                return new QlassifiedBoolean(this.decrypt(entry.getKey()), Boolean.valueOf(decryptedValue));
            }
            case FLOAT: {
                return new QlassifiedFloat(this.decrypt(entry.getKey()), Float.valueOf(decryptedValue));
            }
            case INTEGER: {
                return new QlassifiedInteger(this.decrypt(entry.getKey()), Integer.valueOf(decryptedValue));
            }
            case LONG: {
                return new QlassifiedLong(this.decrypt(entry.getKey()), Long.valueOf(decryptedValue));
            }
        }
        return new QlassifiedString(this.decrypt(entry.getKey()), decryptedValue);
    }

    private boolean checkKeyAvailability() {
        String alias = this.getUniqueDeviceId(this.context);
        try {
            if (!this.keyStoreInstance.containsAlias(alias)) {
                this.createKeys();
            }
            return true;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
            Log.e((String)"QlassifiedKeyStore", (String)String.format("Could not create a KeyStore instance. Stacktrace: %s", e));
            return false;
        }
    }

    private String encrypt(String input) {
        if (!this.checkKeyAvailability()) {
            return null;
        }
        String alias = this.getUniqueDeviceId(this.context);
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStoreInstance.getEntry(alias, null);
            RSAPublicKey publicKey = (RSAPublicKey)privateKeyEntry.getCertificate().getPublicKey();
            return this.crypto.encrypt(input, publicKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            Log.e((String)"QlassifiedKeyStore", (String)String.format("Could not encrypt this string. Stacktrace: %s", e));
            return null;
        }
    }

    private String decrypt(String input) {
        if (!this.checkKeyAvailability()) {
            return null;
        }
        String alias = this.getUniqueDeviceId(this.context);
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStoreInstance.getEntry(alias, null);
            RSAPrivateKey privateKey = (RSAPrivateKey)privateKeyEntry.getPrivateKey();
            return this.crypto.decrypt(input, privateKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            Log.e((String)"QlassifiedKeyStore", (String)String.format("Could not decrypt this string. Stacktrace: %s", e));
            return null;
        }
    }
}

