/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.User;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.util.HttpAuthorizer;
import java.util.Set;

public class PresenceChannelExampleApp
implements ConnectionEventListener,
PresenceChannelEventListener {
    private final Pusher pusher;
    private final String channelName;
    private final String eventName;
    private final PresenceChannel channel;

    public static void main(String[] args) {
        new PresenceChannelExampleApp(args);
    }

    public PresenceChannelExampleApp(String[] args) {
        String apiKey = args.length > 0 ? args[0] : "a87fe72c6f36272aa4b1";
        this.channelName = args.length > 1 ? args[1] : "presence-my-channel";
        this.eventName = args.length > 2 ? args[2] : "my-event";
        HttpAuthorizer authorizer = new HttpAuthorizer("http://www.leggetter.co.uk/pusher/pusher-examples/php/authentication/src/presence_auth.php");
        PusherOptions options = new PusherOptions().setAuthorizer(authorizer).setEncrypted(true);
        this.pusher = new Pusher(apiKey, options);
        this.pusher.connect(this, new ConnectionState[0]);
        this.channel = this.pusher.subscribePresence(this.channelName, this, this.eventName);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void onConnectionStateChange(ConnectionStateChange change) {
        System.out.println(String.format("Connection state changed from [%s] to [%s]", new Object[]{change.getPreviousState(), change.getCurrentState()}));
    }

    @Override
    public void onError(String message, String code, Exception e) {
        System.out.println(String.format("An error was received with message [%s], code [%s], exception [%s]", message, code, e));
    }

    @Override
    public void onUsersInformationReceived(String channelName, Set<User> users) {
        System.out.println("Received user information");
        this.printCurrentlySubscribedUsers();
    }

    @Override
    public void userSubscribed(String channelName, User user) {
        System.out.println(String.format("A new user has joined channel [%s]: %s", channelName, user.toString()));
        this.printCurrentlySubscribedUsers();
    }

    @Override
    public void userUnsubscribed(String channelName, User user) {
        System.out.println(String.format("A user has left channel [%s]: %s", channelName, user));
        this.printCurrentlySubscribedUsers();
    }

    @Override
    public void onEvent(PusherEvent event) {
        System.out.println(String.format("Received event [%s]", event.toString()));
    }

    @Override
    public void onSubscriptionSucceeded(String channelName) {
        System.out.println(String.format("Subscription to channel [%s] succeeded", this.channel.getName()));
    }

    @Override
    public void onAuthenticationFailure(String message, Exception e) {
        System.out.println(String.format("Authentication failure due to [%s], exception was [%s]", message, e));
    }

    private void printCurrentlySubscribedUsers() {
        StringBuilder sb = new StringBuilder("Users now subscribed to the channel:");
        for (User remainingUser : this.channel.getUsers()) {
            sb.append("\n\t");
            sb.append(remainingUser.toString());
            if (!remainingUser.equals(this.channel.getMe())) continue;
            sb.append(" (me)");
        }
        System.out.println(sb.toString());
    }
}

