/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpAuthorizer
implements Authorizer {
    private final URL endPoint;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private Map<String, String> mQueryStringParameters = new HashMap<String, String>();
    private final String ENCODING_CHARACTER_SET = "UTF-8";

    public HttpAuthorizer(String endPoint) {
        try {
            this.endPoint = new URL(endPoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse authentication end point into a valid URL", e);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers;
    }

    public Boolean isSSL() {
        return this.endPoint.getProtocol().equals("https");
    }

    public void setQueryStringParameters(HashMap<String, String> queryStringParameters) {
        this.mQueryStringParameters = queryStringParameters;
    }

    @Override
    public String authorize(String channelName, String socketId) throws AuthorizationFailureException {
        try {
            String line;
            StringBuffer urlParameters = new StringBuffer();
            urlParameters.append("channel_name=").append(URLEncoder.encode(channelName, "UTF-8"));
            urlParameters.append("&socket_id=").append(URLEncoder.encode(socketId, "UTF-8"));
            for (String string : this.mQueryStringParameters.keySet()) {
                urlParameters.append("&").append(string).append("=");
                urlParameters.append(URLEncoder.encode(this.mQueryStringParameters.get(string), "UTF-8"));
            }
            HttpURLConnection connection = this.isSSL() != false ? (HttpsURLConnection)this.endPoint.openConnection() : (HttpURLConnection)this.endPoint.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.toString().getBytes().length));
            for (String headerName : this.mHeaders.keySet()) {
                String headerValue = this.mHeaders.get(headerName);
                connection.setRequestProperty(headerName, headerValue);
            }
            connection.setUseCaches(false);
            DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
            dataOutputStream.writeBytes(urlParameters.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            rd.close();
            int responseHttpStatus = connection.getResponseCode();
            if (responseHttpStatus != 200 && responseHttpStatus != 201) {
                throw new AuthorizationFailureException(response.toString());
            }
            return response.toString();
        }
        catch (IOException e) {
            throw new AuthorizationFailureException(e);
        }
    }
}

