/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Set;

@StatelessCheck
public class SingleLineJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "singleline.javadoc";
    private Set<String> ignoredTags = Set.of();
    private boolean ignoreInlineTags = true;

    public void setIgnoredTags(String ... tags) {
        this.ignoredTags = Set.of(tags);
    }

    public void setIgnoreInlineTags(boolean ignoreInlineTags) {
        this.ignoreInlineTags = ignoreInlineTags;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{1};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (SingleLineJavadocCheck.isSingleLineJavadoc(this.getBlockCommentAst()) && (this.hasJavadocTags(ast) || !this.ignoreInlineTags && this.hasJavadocInlineTags(ast))) {
            this.log(ast.getLineNumber(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isSingleLineJavadoc(DetailAST blockCommentStart) {
        DetailAST blockCommentEnd = blockCommentStart.getLastChild();
        return TokenUtil.areOnSameLine(blockCommentStart, blockCommentEnd);
    }

    private boolean hasJavadocTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtil.findFirstToken(javadocRoot, 75);
        return javadocTagSection != null && !this.isTagIgnored(javadocTagSection);
    }

    private boolean hasJavadocInlineTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtil.findFirstToken(javadocRoot, 6);
        boolean foundTag = false;
        while (javadocTagSection != null) {
            if (!this.isTagIgnored(javadocTagSection)) {
                foundTag = true;
                break;
            }
            javadocTagSection = JavadocUtil.getNextSibling(javadocTagSection, 6);
        }
        return foundTag;
    }

    private boolean isTagIgnored(DetailNode javadocTagSection) {
        String tagName = JavadocUtil.getTagName(javadocTagSection);
        return this.ignoredTags.contains("@" + tagName);
    }
}

