/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.site.JavadocScraperResultUtil;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import java.beans.Introspector;
import java.util.regex.Pattern;

@FileStatefulCheck
public class ClassAndPropertiesSettersJavadocScraper
extends AbstractJavadocCheck {
    private static String moduleName = "";

    public static void initialize(String newModuleName) {
        JavadocScraperResultUtil.clearData();
        moduleName = newModuleName;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{1};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        String className;
        DetailAST classDef;
        DetailAST blockCommentAst = this.getBlockCommentAst();
        if (BlockCommentPosition.isOnMethod(blockCommentAst)) {
            DetailAST methodDef = ClassAndPropertiesSettersJavadocScraper.getParentAst(blockCommentAst, 9);
            if (methodDef != null && ClassAndPropertiesSettersJavadocScraper.isSetterMethod(methodDef) && ClassAndPropertiesSettersJavadocScraper.isMethodOfScrapedModule(methodDef)) {
                String methodName = methodDef.findFirstToken(58).getText();
                String propertyName = ClassAndPropertiesSettersJavadocScraper.getPropertyName(methodName);
                JavadocScraperResultUtil.putPropertyJavadocNode(propertyName, ast);
            }
        } else if (BlockCommentPosition.isOnClass(blockCommentAst) && (classDef = ClassAndPropertiesSettersJavadocScraper.getParentAst(blockCommentAst, 14)) != null && (className = classDef.findFirstToken(58).getText()).equals(moduleName)) {
            JavadocScraperResultUtil.setModuleJavadocNode(ast);
        }
    }

    private static boolean isMethodOfScrapedModule(DetailAST methodDef) {
        DetailAST classDef = ClassAndPropertiesSettersJavadocScraper.getParentAst(methodDef, 14);
        boolean isMethodOfModule = false;
        if (classDef != null) {
            String className = classDef.findFirstToken(58).getText();
            isMethodOfModule = className.equals(moduleName);
        }
        return isMethodOfModule;
    }

    private static DetailAST getParentAst(DetailAST ast, int type) {
        DetailAST node;
        for (node = ast.getParent(); node != null && node.getType() != type; node = node.getParent()) {
        }
        return node;
    }

    private static String getPropertyName(String setterName) {
        return Introspector.decapitalize(setterName.substring("set".length()));
    }

    private static boolean isSetterMethod(DetailAST ast) {
        boolean setterMethod = false;
        if (ast.getType() == 9) {
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            Pattern setterPattern = Pattern.compile("^set[A-Z].*");
            setterMethod = setterPattern.matcher(name).matches();
        }
        return setterMethod;
    }
}

