/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class RedundantImportCheck
extends AbstractCheck {
    public static final String MSG_LANG = "import.lang";
    public static final String MSG_SAME = "import.same";
    public static final String MSG_DUPLICATE = "import.duplicate";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private final Set<FullIdent> staticImports = new HashSet<FullIdent>();
    private String pkgName;

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.pkgName = null;
        this.imports.clear();
        this.staticImports.clear();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.pkgName = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling()).getText();
        } else if (ast.getType() == 30) {
            FullIdent imp = FullIdent.createFullIdentBelow(ast);
            String importText = imp.getText();
            if (RedundantImportCheck.isFromPackage(importText, "java.lang")) {
                this.log(ast, MSG_LANG, importText);
            } else if (this.pkgName != null && RedundantImportCheck.isFromPackage(importText, this.pkgName)) {
                this.log(ast, MSG_SAME, importText);
            }
            this.imports.stream().filter(full -> importText.equals(full.getText())).forEach(full -> this.log(ast, MSG_DUPLICATE, full.getLineNo(), importText));
            this.imports.add(imp);
        } else {
            FullIdent imp = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling());
            this.staticImports.stream().filter(full -> imp.getText().equals(full.getText())).forEach(full -> this.log(ast, MSG_DUPLICATE, full.getLineNo(), imp.getText()));
            this.staticImports.add(imp);
        }
    }

    private static boolean isFromPackage(String importName, String pkg) {
        int index = importName.lastIndexOf(46);
        String front = importName.substring(0, index);
        return pkg.equals(front);
    }
}

