/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;

@FileStatefulCheck
public class UnusedCatchParameterShouldBeUnnamedCheck
extends AbstractCheck {
    public static final String MSG_UNUSED_CATCH_PARAMETER = "unused.catch.parameter";
    private static final int[] INVALID_CATCH_PARAM_IDENT_PARENTS = new int[]{59, 136, 27, 13};
    private final Deque<CatchParameterDetails> catchParameters = new ArrayDeque<CatchParameterDetails>();

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{96, 58};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.catchParameters.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 96) {
            CatchParameterDetails catchParameter = new CatchParameterDetails(ast);
            this.catchParameters.push(catchParameter);
        } else if (UnusedCatchParameterShouldBeUnnamedCheck.isCatchParameterIdentifierCandidate(ast) && !UnusedCatchParameterShouldBeUnnamedCheck.isLeftHandOfAssignment(ast)) {
            this.catchParameters.stream().filter(parameter -> parameter.getName().equals(ast.getText())).findFirst().ifPresent(CatchParameterDetails::registerAsUsed);
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 96) {
            Optional<CatchParameterDetails> unusedCatchParameter = Optional.ofNullable(this.catchParameters.peek()).filter(parameter -> !parameter.isUsed()).filter(parameter -> !"_".equals(parameter.getName()));
            unusedCatchParameter.ifPresent(parameter -> this.log(parameter.getParameterDefinition(), MSG_UNUSED_CATCH_PARAMETER, parameter.getName()));
            this.catchParameters.pop();
        }
    }

    private static boolean isCatchParameterIdentifierCandidate(DetailAST identifierAst) {
        return identifierAst.getParent().getParent().getType() != 96 && (!TokenUtil.isOfType(identifierAst.getParent(), INVALID_CATCH_PARAM_IDENT_PARENTS) || UnusedCatchParameterShouldBeUnnamedCheck.isMethodInvocation(identifierAst));
    }

    private static boolean isMethodInvocation(DetailAST identAst) {
        DetailAST parent = identAst.getParent();
        return parent.getType() == 59 && identAst.equals(parent.getFirstChild());
    }

    private static boolean isLeftHandOfAssignment(DetailAST identAst) {
        DetailAST parent = identAst.getParent();
        return parent.getType() == 80 && !identAst.equals(parent.getLastChild());
    }

    private static final class CatchParameterDetails {
        private final String name;
        private final DetailAST parameterDefinition;
        private boolean used;

        private CatchParameterDetails(DetailAST enclosingCatchClause) {
            this.parameterDefinition = enclosingCatchClause.findFirstToken(21);
            this.name = this.parameterDefinition.findFirstToken(58).getText();
        }

        private void registerAsUsed() {
            this.used = true;
        }

        private String getName() {
            return this.name;
        }

        private boolean isUsed() {
            return this.used;
        }

        private DetailAST getParameterDefinition() {
            return this.parameterDefinition;
        }
    }
}

