/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.GlobalStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GlobalStatefulCheck
public class JavadocLeadingAsteriskAlignCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "javadoc.asterisk.indentation";
    private int javadocStartLineNumber;
    private int expectedColumnNumberTabsExpanded;
    private int expectedColumnNumberWithoutExpandedTabs;
    private String[] fileLines;

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{1};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void beginJavadocTree(DetailNode rootAst) {
        this.fileLines = this.getLines();
        String startLine = this.fileLines[rootAst.getLineNumber() - 1];
        this.javadocStartLineNumber = rootAst.getLineNumber();
        this.expectedColumnNumberTabsExpanded = CommonUtil.lengthExpandedTabs(startLine, rootAst.getColumnNumber() - 1, this.getTabWidth());
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        boolean isJavadocStartingLine;
        boolean bl = isJavadocStartingLine = ast.getLineNumber() == this.javadocStartLineNumber;
        if (!isJavadocStartingLine) {
            Optional<Integer> leadingAsteriskColumnNumber = JavadocLeadingAsteriskAlignCheck.getAsteriskColumnNumber(ast.getText());
            leadingAsteriskColumnNumber.map(columnNumber -> this.expandedTabs(ast.getText(), (int)columnNumber)).filter(columnNumber -> !JavadocLeadingAsteriskAlignCheck.hasValidAlignment(this.expectedColumnNumberTabsExpanded, columnNumber)).ifPresent(columnNumber -> this.logViolation(ast.getLineNumber(), (int)columnNumber, this.expectedColumnNumberTabsExpanded));
        }
    }

    @Override
    public void finishJavadocTree(DetailNode rootAst) {
        DetailAST javadocEndToken = this.getBlockCommentAst().getLastChild();
        String lastLine = this.fileLines[javadocEndToken.getLineNo() - 1];
        Optional<Integer> endingBlockColumnNumber = JavadocLeadingAsteriskAlignCheck.getAsteriskColumnNumber(lastLine);
        endingBlockColumnNumber.map(columnNumber -> this.expandedTabs(lastLine, (int)columnNumber)).filter(columnNumber -> !JavadocLeadingAsteriskAlignCheck.hasValidAlignment(this.expectedColumnNumberTabsExpanded, columnNumber)).ifPresent(columnNumber -> this.logViolation(javadocEndToken.getLineNo(), (int)columnNumber, this.expectedColumnNumberTabsExpanded));
    }

    private int expandedTabs(String line, int columnNumber) {
        this.expectedColumnNumberWithoutExpandedTabs = columnNumber - 1;
        return CommonUtil.lengthExpandedTabs(line, columnNumber, this.getTabWidth());
    }

    private static Optional<Integer> getAsteriskColumnNumber(String line) {
        Pattern pattern = Pattern.compile("^(\\s*)\\*");
        Matcher matcher = pattern.matcher(line);
        return Optional.of(matcher).filter(Matcher::find).map(matcherInstance -> matcherInstance.group(1)).map(groupLength -> groupLength.length() + 1);
    }

    private void logViolation(int lineNumber, int asteriskColNumber, int expectedColNumber) {
        this.log(lineNumber, this.expectedColumnNumberWithoutExpandedTabs, MSG_KEY, asteriskColNumber, expectedColNumber);
    }

    private static boolean hasValidAlignment(int expectedColNumber, int asteriskColNumber) {
        return expectedColNumber - asteriskColNumber == 0;
    }
}

