/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;

@FileStatefulCheck
public class UnusedLambdaParameterShouldBeUnnamedCheck
extends AbstractCheck {
    public static final String MSG_UNUSED_LAMBDA_PARAMETER = "unused.lambda.parameter";
    private static final int[] INVALID_LAMBDA_PARAM_IDENT_PARENTS = new int[]{59, 136, 27, 13};
    private final Deque<LambdaParameterDetails> lambdaParameters = new ArrayDeque<LambdaParameterDetails>();

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{181, 58};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.lambdaParameters.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 181) {
            DetailAST parameters = ast.findFirstToken(20);
            if (parameters != null) {
                TokenUtil.forEachChild(parameters, 21, parameter -> {
                    DetailAST identifierAst = parameter.findFirstToken(58);
                    LambdaParameterDetails lambdaParameter = new LambdaParameterDetails(ast, identifierAst);
                    this.lambdaParameters.push(lambdaParameter);
                });
            } else if (ast.getChildCount() != 0) {
                LambdaParameterDetails lambdaParameter = new LambdaParameterDetails(ast, ast.findFirstToken(58));
                this.lambdaParameters.push(lambdaParameter);
            }
        } else if (UnusedLambdaParameterShouldBeUnnamedCheck.isLambdaParameterIdentifierCandidate(ast) && !UnusedLambdaParameterShouldBeUnnamedCheck.isLeftHandOfAssignment(ast)) {
            this.lambdaParameters.stream().filter(parameter -> parameter.getName().equals(ast.getText())).findFirst().ifPresent(rec$ -> ((LambdaParameterDetails)rec$).registerAsUsed());
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        while (this.lambdaParameters.peek() != null && ast.equals(this.lambdaParameters.peek().enclosingLambda)) {
            Optional<LambdaParameterDetails> unusedLambdaParameter = Optional.ofNullable(this.lambdaParameters.peek()).filter(parameter -> !parameter.isUsed()).filter(parameter -> !"_".equals(parameter.getName()));
            unusedLambdaParameter.ifPresent(parameter -> this.log(parameter.getIdentifierAst(), MSG_UNUSED_LAMBDA_PARAMETER, parameter.getName()));
            this.lambdaParameters.pop();
        }
    }

    private static boolean isLambdaParameterIdentifierCandidate(DetailAST identifierAst) {
        boolean isLambdaParameterDeclaration = identifierAst.getParent().getType() == 181 || identifierAst.getParent().getType() == 21;
        return !isLambdaParameterDeclaration && (UnusedLambdaParameterShouldBeUnnamedCheck.hasValidParentToken(identifierAst) || UnusedLambdaParameterShouldBeUnnamedCheck.isMethodInvocation(identifierAst));
    }

    private static boolean hasValidParentToken(DetailAST identifierAst) {
        return !TokenUtil.isOfType(identifierAst.getParent(), INVALID_LAMBDA_PARAM_IDENT_PARENTS);
    }

    private static boolean isMethodInvocation(DetailAST identAst) {
        DetailAST parent = identAst.getParent();
        return parent.getType() == 59 && identAst.equals(parent.getFirstChild());
    }

    private static boolean isLeftHandOfAssignment(DetailAST identAst) {
        DetailAST parent = identAst.getParent();
        return parent.getType() == 80 && !identAst.equals(parent.getLastChild());
    }

    private static final class LambdaParameterDetails {
        private final DetailAST enclosingLambda;
        private final DetailAST identifierAst;
        private boolean used;

        private LambdaParameterDetails(DetailAST enclosingLambda, DetailAST identifierAst) {
            this.enclosingLambda = enclosingLambda;
            this.identifierAst = identifierAst;
        }

        private void registerAsUsed() {
            this.used = true;
        }

        private String getName() {
            return this.identifierAst.getText();
        }

        private DetailAST getIdentifierAst() {
            return this.identifierAst;
        }

        private boolean isUsed() {
            return this.used;
        }
    }
}

