/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.utils.CodePointTranslator;
import java.io.IOException;
import java.io.Writer;

class UnicodeEscaper
extends CodePointTranslator {
    private final int below;
    private final int above;
    private final boolean between;

    static UnicodeEscaper above(int codePoint) {
        return UnicodeEscaper.outsideOf(0, codePoint);
    }

    static UnicodeEscaper below(int codePoint) {
        return UnicodeEscaper.outsideOf(codePoint, Integer.MAX_VALUE);
    }

    static UnicodeEscaper between(int codePointLow, int codePointHigh) {
        return new UnicodeEscaper(codePointLow, codePointHigh, true);
    }

    static UnicodeEscaper outsideOf(int codePointLow, int codePointHigh) {
        return new UnicodeEscaper(codePointLow, codePointHigh, false);
    }

    UnicodeEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    protected UnicodeEscaper(int below, int above, boolean between) {
        this.below = below;
        this.above = above;
        this.between = between;
    }

    protected String toUtf16Escape(int codePoint) {
        return "\\u" + UnicodeEscaper.hex(codePoint);
    }

    @Override
    boolean translate(int codePoint, Writer writer) throws IOException {
        if (this.between ? codePoint < this.below || codePoint > this.above : codePoint >= this.below && codePoint <= this.above) {
            return false;
        }
        if (codePoint > 65535) {
            writer.write(this.toUtf16Escape(codePoint));
        } else {
            writer.write("\\u");
            writer.write(HEX_DIGITS[codePoint >> 12 & 0xF]);
            writer.write(HEX_DIGITS[codePoint >> 8 & 0xF]);
            writer.write(HEX_DIGITS[codePoint >> 4 & 0xF]);
            writer.write(HEX_DIGITS[codePoint & 0xF]);
        }
        return true;
    }
}

