/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field405
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "405";
    public static final String F_405 = "405";
    public static final Integer REASON_FOR_REJECTION = 1;
    public static final Integer LINE_FIELD_NUMBER = 2;

    public Field405() {
        super(2);
    }

    public Field405(String value) {
        super(value);
    }

    public Field405(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"405")) {
            throw new IllegalArgumentException("cannot create field 405 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field405 newInstance(Field405 source) {
        Field405 cp = new Field405();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("405", value);
    }

    public static Tag emptyTag() {
        return new Tag("405", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            if (value.length() >= 3) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)3));
            }
            if (value.length() > 3) {
                this.setComponent2(StringUtils.substring((String)value, (int)3));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 405");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SN";
    }

    @Override
    public String parserPattern() {
        return "3!SN";
    }

    @Override
    public String validatorPattern() {
        return "3!c[3!n]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Reason For Rejection");
        result.add("Line Field Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "reasonForRejection");
        result.put(2, "lineFieldNumber");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("reasonforrejection", 1);
        this.labelMap.put("linefieldnumber", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getReasonForRejection() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getLineFieldNumber() {
        return this.getComponent2();
    }

    public Long getLineFieldNumberAsLong() {
        return this.getComponent2AsLong();
    }

    public Field405 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field405 setReasonForRejection(String component1) {
        return this.setComponent1(component1);
    }

    public Field405 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field405 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field405 setLineFieldNumber(String component2) {
        return this.setComponent2(component2);
    }

    public Field405 setLineFieldNumber(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "405";
    }

    public static Field405 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("405");
        if (t == null) {
            return null;
        }
        return new Field405(t);
    }

    public static Field405 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field405.get(msg.getBlock4());
    }

    public static List<Field405> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field405.getAll(msg.getBlock4());
    }

    public static List<Field405> getAll(SwiftTagListBlock block) {
        ArrayList<Field405> result = new ArrayList<Field405>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("405");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field405(f));
            }
        }
        return result;
    }

    public static Field405 fromJson(String json) {
        Field405 field = new Field405();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("reasonForRejection") != null) {
            field.setComponent1(jsonObject.get("reasonForRejection").getAsString());
        }
        if (jsonObject.get("lineFieldNumber") != null) {
            field.setComponent2(jsonObject.get("lineFieldNumber").getAsString());
        }
        return field;
    }
}

