/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field21H
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "21H";
    public static final String F_21H = "21H";
    public static final Integer EVENT_TYPE = 1;
    public static final Integer REFERENCE = 2;

    public Field21H() {
        super(2);
    }

    public Field21H(String value) {
        super(value);
    }

    public Field21H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"21H")) {
            throw new IllegalArgumentException("cannot create field 21H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field21H newInstance(Field21H source) {
        Field21H cp = new Field21H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("21H", value);
    }

    public static Tag emptyTag() {
        return new Tag("21H", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 21H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S/S";
    }

    @Override
    public String validatorPattern() {
        return "4!c/16x(**)(***)";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Event Type");
        result.add("Reference");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "eventType");
        result.put(2, "reference");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("eventtype", 1);
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("reference", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getEventType() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getReference() {
        return this.getComponent2();
    }

    public Field21H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field21H setEventType(String component1) {
        return this.setComponent1(component1);
    }

    public Field21H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field21H setReference(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "21H";
    }

    public static Field21H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("21H");
        if (t == null) {
            return null;
        }
        return new Field21H(t);
    }

    public static Field21H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field21H.get(msg.getBlock4());
    }

    public static List<Field21H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field21H.getAll(msg.getBlock4());
    }

    public static List<Field21H> getAll(SwiftTagListBlock block) {
        ArrayList<Field21H> result = new ArrayList<Field21H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("21H");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field21H(f));
            }
        }
        return result;
    }

    public static Field21H fromJson(String json) {
        Field21H field = new Field21H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("eventType") != null) {
            field.setComponent1(jsonObject.get("eventType").getAsString());
        }
        if (jsonObject.get("reference") != null) {
            field.setComponent2(jsonObject.get("reference").getAsString());
        }
        return field;
    }
}

